/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public final class CurrentSelectionSourceProvider
extends AbstractSourceProvider
implements INullSelectionListener {
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"selection"};
    private final IWindowListener windowListener = new IWindowListener(){

        public final void windowActivated(IWorkbenchWindow window) {
            CurrentSelectionSourceProvider.this.swapListeners(window, false);
        }

        public final void windowClosed(IWorkbenchWindow window) {
            CurrentSelectionSourceProvider.this.swapListeners(window, true);
        }

        public final void windowDeactivated(IWorkbenchWindow window) {
            CurrentSelectionSourceProvider.this.swapListeners(window, true);
        }

        public final void windowOpened(IWorkbenchWindow window) {
            CurrentSelectionSourceProvider.this.swapListeners(window, false);
        }
    };
    private final IWorkbench workbench;

    public CurrentSelectionSourceProvider(IWorkbench workbench) {
        this.workbench = workbench;
        workbench.addWindowListener(this.windowListener);
    }

    public final void dispose() {
        this.workbench.removeWindowListener(this.windowListener);
    }

    public final Map getCurrentState() {
        TreeMap<String, ISelection> currentState = new TreeMap<String, ISelection>();
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        if (window != null) {
            ISelectionService service = window.getSelectionService();
            ISelection selection = service.getSelection();
            currentState.put("selection", selection);
        } else {
            currentState.put("selection", null);
        }
        return currentState;
    }

    public final String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    public final void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (DEBUG) {
            this.logDebuggingInfo("Selection changed to " + selection);
        }
        this.fireSourceChanged(0x40000000, "selection", selection);
    }

    private final void swapListeners(IWorkbenchWindow window, boolean remove) {
        ISelectionService selectionService = window.getSelectionService();
        if (remove) {
            window.getSelectionService().removeSelectionListener(this);
            this.selectionChanged(null, null);
        } else {
            window.getSelectionService().addSelectionListener(this);
            this.selectionChanged(null, selectionService.getSelection());
        }
    }
}

