/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.tadotter.actions;

import com.hisagisoft.common.IMonitor;
import com.hisagisoft.eclipse.tadotter.Activator;
import com.hisagisoft.eclipse.tadotter.views.TrackView;
import com.hisagisoft.tadotter.Service;
import com.hisagisoft.twitter.FailedGetPageException;
import com.hisagisoft.twitter.model.Twitter;
import com.hisagisoft.twitter.model.TwitterList;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RefreshAction
extends Action {
    private static Logger logger = Logger.getLogger(RefreshAction.class.getName());
    private TrackView view;
    private IStatusLineManager statusLine;
    private TwitterList list;
    private boolean isJPNOnly = true;
    private MenuItem itemJPN;
    private MenuItem itemAllLang;
    private int[] limits = new int[]{3, 5, 10, 30, 100};
    private int maxSize = 30;

    public RefreshAction() {
        this.setText("\u30bf\u30c9\u308a\u307e\u3059");
        this.setToolTipText("\u30bf\u30c9\u308a\u307e\u3059");
        this.setImageDescriptor(Activator.getImageDescriptor("icons/e16/run.gif"));
        this.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/d16/run.gif"));
        IMenuCreator creator = this.createMenuCreator();
        this.setMenuCreator(creator);
    }

    private IMenuCreator createMenuCreator() {
        final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.isJPNOnly = store.getBoolean("LANG_JPN_ONLY");
        this.maxSize = store.getInt("MAX_SIZE");
        IMenuCreator creator = null;
        creator = new IMenuCreator(){

            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                Menu menu = new Menu(parent);
                RefreshAction.this.itemJPN = new MenuItem(menu, 36);
                RefreshAction.this.itemJPN.setText("\u65e5\u672c\u8a9e\u306e\u307f");
                RefreshAction.this.itemJPN.setSelection(RefreshAction.this.isJPNOnly);
                RefreshAction.this.itemAllLang = new MenuItem(menu, 36);
                RefreshAction.this.itemAllLang.setText("\u3059\u3079\u3066\u306e\u8a00\u8a9e");
                RefreshAction.this.itemAllLang.setSelection(!RefreshAction.this.isJPNOnly);
                RefreshAction.this.itemJPN.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        RefreshAction.this.isJPNOnly = true;
                        store.setValue("LANG_JPN_ONLY", RefreshAction.this.isJPNOnly);
                    }
                });
                RefreshAction.this.itemAllLang.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        RefreshAction.this.isJPNOnly = false;
                        store.setValue("LANG_JPN_ONLY", RefreshAction.this.isJPNOnly);
                    }
                });
                new MenuItem(menu, 2);
                int i = 0;
                while (i < RefreshAction.this.limits.length) {
                    int limit = RefreshAction.this.limits[i];
                    final MenuItem item = new MenuItem(menu, 36);
                    item.setText("\u6700\u5927\u30bf\u30c9\u308a " + String.valueOf(limit));
                    item.setData((Object)limit);
                    item.setSelection(limit == RefreshAction.this.maxSize);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RefreshAction.this.maxSize = (Integer)item.getData();
                            store.setValue("MAX_SIZE", RefreshAction.this.maxSize);
                        }
                    });
                    ++i;
                }
                return menu;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }
        };
        return creator;
    }

    public void run() {
        block7: {
            logger.fine("Refresh Action - START");
            IWorkbenchWindow window = null;
            try {
                window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                this.view = (TrackView)window.getActivePage().showView("com.hisagisoft.eclipse.tadotter.TrackView");
                this.statusLine = this.view.getViewSite().getActionBars().getStatusLineManager();
                this.setEnabled(false);
                this.statusLine.setMessage("");
                window.run(true, true, new IRunnableWithProgress(){

                    public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        Service service = Service.getInstance();
                        service.setMonitor(new IMonitor(){

                            public boolean isCanceled() {
                                return monitor.isCanceled();
                            }

                            public void setCanceled(boolean value) {
                            }

                            public void setTaskName(String name) {
                                monitor.setTaskName(name);
                            }

                            public void subTask(String name) {
                                monitor.subTask(name);
                            }

                            public void worked(int work) {
                                monitor.worked(work);
                            }
                        });
                        service.setJPNOnly(RefreshAction.this.isJPNOnly);
                        service.setMaxSize(RefreshAction.this.maxSize);
                        logger.fine("maxSize = " + RefreshAction.this.maxSize + ", isJPNOnly = " + RefreshAction.this.isJPNOnly);
                        monitor.beginTask("\u30bf\u30c9\u3063\u3066\u3044\u307e\u3059", service.getMaxSize());
                        try {
                            try {
                                service.trackFromRoot();
                                RefreshAction.this.list = service.getTwitterList();
                                if (RefreshAction.this.list.size() == RefreshAction.this.maxSize) {
                                    Twitter t = new Twitter();
                                    t.setType(Twitter.Type.SYSTEM_STATUS);
                                    t.setMessage("\u6700\u5927\u30bf\u30c9\u308a\u6570\u306b\u9054\u3057\u307e\u3057\u305f");
                                    RefreshAction.this.list.add(t);
                                }
                            }
                            catch (InterruptedException e) {
                                RefreshAction.this.list = service.getTwitterList();
                                Twitter t = new Twitter();
                                t.setType(Twitter.Type.SYSTEM_STATUS);
                                t.setMessage("\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f");
                                RefreshAction.this.list.add(t);
                                throw e;
                            }
                            catch (FailedGetPageException e) {
                                RefreshAction.this.list = service.getTwitterList();
                                Twitter t = new Twitter();
                                t.setType(Twitter.Type.SYSTEM_STATUS);
                                switch (e.getType()) {
                                    case FileNotFound: {
                                        t.setMessage("URL\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3053\u3053\u3067\u4e2d\u6b62\u3057\u307e\u3057\u305f");
                                        RefreshAction.this.list.add(t);
                                        break;
                                    }
                                    case Connect: {
                                        t.setMessage("Twitter\u304c\u306a\u304b\u306a\u304b\u5fdc\u7b54\u3092\u8fd4\u3055\u306a\u3044\u306e\u3067\u4e2d\u6b62\u3057\u307e\u3057\u305f");
                                        RefreshAction.this.list.add(t);
                                        break;
                                    }
                                    case IO: {
                                        t.setMessage("Twitter\u304c\u7570\u5e38\u306a\u5fdc\u7b54\u3092\u8fd4\u3057\u305f\u306e\u3067\u4e2d\u6b62\u3057\u307e\u3057\u305f");
                                        RefreshAction.this.list.add(t);
                                        break;
                                    }
                                    case Parse: {
                                        t.setMessage("Twitter\u304c\u8fd4\u3057\u305f\u30da\u30fc\u30b8\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u305f\u306e\u3067\u4e2d\u6b62\u3057\u307e\u3057\u305f");
                                        RefreshAction.this.list.add(t);
                                        break;
                                    }
                                    default: {
                                        throw new Error();
                                    }
                                }
                                monitor.done();
                            }
                            catch (Throwable e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                logger.fine("\u30ad\u30e3\u30f3\u30bb\u30eb\u3092\u53d7\u3051\u4ed8\u3051\u307e\u3057\u305f");
                this.setEnabled(true);
                window.getActivePage().activate((IWorkbenchPart)this.view);
                break block7;
            }
            catch (Throwable e) {
                try {
                    ILog plugInLogger = Activator.getDefault().getLog();
                    Status status = new Status(4, "com.hisagisoft.eclipse.tadotter", e.getMessage(), e);
                    plugInLogger.log((IStatus)status);
                    e.printStackTrace();
                    MessageDialog.openError((Shell)this.view.getSite().getShell(), (String)"\u30a8\u30e9\u30fc", (String)("\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f  - " + e));
                    break block7;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.setEnabled(true);
                    window.getActivePage().activate((IWorkbenchPart)this.view);
                }
            }
            this.setEnabled(true);
            window.getActivePage().activate((IWorkbenchPart)this.view);
        }
        this.view.setInput(this.list);
        logger.fine("Refresh Action - END");
    }
}

