/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.PartListenerList;
import org.eclipse.ui.internal.PartListenerList2;
import org.eclipse.ui.internal.misc.UIListenerLogging;

public class PartService
implements IPartService {
    private PartListenerList listeners = new PartListenerList();
    private PartListenerList2 listeners2 = new PartListenerList2();
    private IWorkbenchPartReference activePart = null;
    private String debugListenersKey;
    private String debugListeners2Key;

    public PartService(String debugListenersKey, String debugListeners2Key) {
        this.debugListeners2Key = debugListeners2Key;
        this.debugListenersKey = debugListenersKey;
    }

    public void addPartListener(IPartListener l) {
        this.listeners.addPartListener(l);
    }

    public void addPartListener(IPartListener2 l) {
        this.listeners2.addPartListener(l);
    }

    public void removePartListener(IPartListener l) {
        this.listeners.removePartListener(l);
    }

    public void removePartListener(IPartListener2 l) {
        this.listeners2.removePartListener(l);
    }

    private void firePartActivated(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        if (part != null) {
            UIListenerLogging.logPartListenerEvent(this.debugListenersKey, this, part, "partActivated");
            this.listeners.firePartActivated(part);
        }
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, ref, "partActivated");
        this.listeners2.firePartActivated(ref);
    }

    public void firePartBroughtToTop(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        if (part != null) {
            UIListenerLogging.logPartListenerEvent(this.debugListenersKey, this, part, "partBroughtToTop");
            this.listeners.firePartBroughtToTop(part);
        }
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, ref, "partBroughtToTop");
        this.listeners2.firePartBroughtToTop(ref);
    }

    public void firePartClosed(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        if (part != null) {
            UIListenerLogging.logPartListenerEvent(this.debugListenersKey, this, part, "partClosed");
            this.listeners.firePartClosed(part);
        }
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, ref, "partClosed");
        this.listeners2.firePartClosed(ref);
    }

    private void firePartDeactivated(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        if (part != null) {
            UIListenerLogging.logPartListenerEvent(this.debugListenersKey, this, part, "partDeactivated");
            this.listeners.firePartDeactivated(part);
        }
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, ref, "partDectivated");
        this.listeners2.firePartDeactivated(ref);
    }

    public void firePartVisible(IWorkbenchPartReference ref) {
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, ref, "partVisible");
        this.listeners2.firePartVisible(ref);
    }

    public void firePartHidden(IWorkbenchPartReference ref) {
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, ref, "partHidden");
        this.listeners2.firePartHidden(ref);
    }

    public void firePartInputChanged(IWorkbenchPartReference ref) {
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, ref, "partInputChanged");
        this.listeners2.firePartInputChanged(ref);
    }

    public void firePartOpened(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        if (part != null) {
            UIListenerLogging.logPartListenerEvent(this.debugListenersKey, this, part, "partOpened");
            this.listeners.firePartOpened(part);
        }
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, ref, "partOpened");
        this.listeners2.firePartOpened(ref);
    }

    public IWorkbenchPart getActivePart() {
        return this.activePart == null ? null : this.activePart.getPart(false);
    }

    public IWorkbenchPartReference getActivePartReference() {
        return this.activePart;
    }

    public void setActivePart(IWorkbenchPartReference ref) {
        IWorkbenchPartReference oldRef = this.activePart;
        if (oldRef == ref) {
            return;
        }
        if (oldRef != null) {
            this.firePartDeactivated(oldRef);
        }
        this.activePart = ref;
        if (ref != null) {
            this.firePartActivated(ref);
        }
    }
}

