/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    int itemCount;
    MenuItem cascade;
    MenuItem selected;
    Decorations parent;

    public Menu(Control parent) {
        this(Menu.checkNull(parent).menuShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        this(parent, Menu.checkStyle(style), 0);
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    Menu(Decorations parent, int style, int handle) {
        super(parent, Menu.checkStyle(style));
        this.parent = parent;
        this.handle = handle;
        this.createWidget();
    }

    void _setVisible(boolean visible) {
        if ((this.style & 6) != 0) {
            return;
        }
        OS.ContextMenu_IsOpen(this.handle, visible);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static int checkStyle(int style) {
        return Menu.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    void createHandle() {
        int bits = 14;
        switch (this.style & bits) {
            case 2: {
                this.handle = OS.gcnew_Menu();
                if (this.handle != 0) break;
                SWT.error(2);
                break;
            }
            case 8: {
                this.handle = OS.gcnew_ContextMenu();
                if (this.handle == 0) {
                    SWT.error(2);
                }
                OS.ContextMenu_Placement(this.handle, 8);
                break;
            }
            case 4: {
                this.handle = OS.gcnew_CompositeCollection();
                if (this.handle == 0) {
                    SWT.error(2);
                }
                int defaultItem = OS.gcnew_MenuItem();
                OS.CompositeCollection_Insert(this.handle, 0, defaultItem);
                OS.GCHandle_Free(defaultItem);
            }
        }
    }

    void createItem(MenuItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        item.createWidget();
        if ((this.style & 4) != 0) {
            if (this.itemCount == 0) {
                OS.CompositeCollection_RemoveAt(this.handle, 0);
            }
            OS.CompositeCollection_Insert(this.handle, index, item.handle);
        } else {
            int items = OS.ItemsControl_Items(this.handle);
            OS.ItemCollection_Insert(items, index, item.handle);
            OS.GCHandle_Free(items);
        }
        ++this.itemCount;
    }

    void createWidget() {
        this.checkOrientation(this.parent);
        super.createWidget();
        this.parent.addMenu(this);
    }

    void deregister() {
        if ((this.style & 4) != 0) {
            return;
        }
        this.display.removeWidget(this.handle);
    }

    void destroyItem(MenuItem item) {
        if ((this.style & 4) != 0) {
            OS.CompositeCollection_Remove(this.handle, item.handle);
            if (this.itemCount == 1) {
                int defaultItem = OS.gcnew_MenuItem();
                OS.CompositeCollection_Insert(this.handle, 0, defaultItem);
                OS.GCHandle_Free(defaultItem);
            }
        } else {
            int items = OS.ItemsControl_Items(this.handle);
            OS.ItemCollection_Remove(items, item.handle);
            OS.GCHandle_Free(items);
        }
        --this.itemCount;
    }

    void fixMenus(Decorations newParent) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].fixMenus(newParent);
            ++i;
        }
        this.parent.removeMenu(this);
        newParent.addMenu(this);
        this.parent = newParent;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (!OS.UIElement_IsVisible(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int point = OS.gcnew_Point(0.0, 0.0);
        int location = OS.UIElement_TranslatePoint(this.handle, point, this.parent.handle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        int width = (int)OS.FrameworkElement_ActualWidth(this.handle);
        int height = (int)OS.FrameworkElement_ActualHeight(this.handle);
        return new Rectangle(x, y, width, height);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return null;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if ((this.style & 4) != 0) {
            return this.getItem(this.handle, index);
        }
        int items = OS.ItemsControl_Items(this.handle);
        MenuItem result = this.getItem(items, index);
        OS.GCHandle_Free(items);
        return result;
    }

    MenuItem getItem(int items, int index) {
        int item = (this.style & 4) != 0 ? OS.IList_default(this.handle, index) : OS.ItemCollection_GetItemAt(items, index);
        MenuItem result = (MenuItem)this.display.getWidget(item);
        OS.GCHandle_Free(item);
        return result;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        MenuItem[] result = new MenuItem[this.itemCount];
        int items = (this.style & 4) == 0 ? OS.ItemsControl_Items(this.handle) : this.handle;
        int i = 0;
        while (i < this.itemCount) {
            result[i] = this.getItem(items, i);
            ++i;
        }
        if (items != this.handle) {
            OS.GCHandle_Free(items);
        }
        return result;
    }

    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                result = String.valueOf(result) + items[i].getNameText() + ", ";
                ++i;
            }
            result = String.valueOf(result) + items[length - 1].getNameText();
        }
        return result;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return this == this.parent.menuShell().menuBar;
        }
        if ((this.style & 8) != 0) {
            Menu[] popups = this.display.popups;
            if (popups == null) {
                return false;
            }
            int i = 0;
            while (i < popups.length) {
                if (popups[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        return OS.UIElement_Visibility(this.handle) == 0;
    }

    void HandleClosed(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.sendEvent(23);
    }

    void HandleOpened(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.sendEvent(22);
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 8) != 0) {
            int handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleClosed");
            OS.ContextMenu_Closed(this.handle, handler);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleOpened");
            OS.ContextMenu_Opened(this.handle, handler);
            OS.GCHandle_Free(handler);
        }
    }

    public int indexOf(MenuItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int index = -1;
        if ((this.style & 4) != 0) {
            index = OS.CompositeCollection_IndexOf(this.handle, item.handle);
        } else {
            int items = OS.ItemsControl_Items(this.handle);
            index = OS.ItemCollection_IndexOf(items, item.handle);
            OS.GCHandle_Free(items);
        }
        return index;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void register() {
        if ((this.style & 4) != 0) {
            return;
        }
        this.display.addWidget(this.handle, this);
    }

    void releaseChildren(boolean destroy) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.releaseMenu();
        }
        if ((this.style & 2) != 0) {
            if (this == this.parent.menuBar) {
                this.parent.setMenuBar(null);
            }
        } else if ((this.style & 8) != 0) {
            this.display.removePopup(this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
        this.parent = null;
        this.cascade = null;
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener);
        this.eventTable.unhook(22, listener);
    }

    public void setDefaultItem(MenuItem item) {
        this.checkWidget();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state &= 0xFFFFFFF7;
        if (!enabled) {
            this.state |= 8;
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        OS.ContextMenu_Placement(this.handle, 5);
        OS.ContextMenu_HorizontalOffset(this.handle, x);
        OS.ContextMenu_VerticalOffset(this.handle, y);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            SWT.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (visible) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }
}

