/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends Item {
    Tree parent;
    Image[] images;
    int itemCount;
    int stringList;
    int imageList;
    int foregroundList;
    int backgroundList;
    int fontList;
    int checkState;
    boolean checked;
    boolean grayed;
    boolean cached;
    boolean ignoreNotify;

    public TreeItem(Tree parent, int style) {
        this(TreeItem.checkNull(parent), null, style, parent.itemCount, 0);
    }

    public TreeItem(Tree parent, int style, int index) {
        this(TreeItem.checkNull(parent), null, style, index, 0);
    }

    public TreeItem(TreeItem parentItem, int style) {
        this(TreeItem.checkNull((TreeItem)parentItem).parent, parentItem, style, parentItem.itemCount, 0);
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        this(TreeItem.checkNull((TreeItem)parentItem).parent, parentItem, style, index, 0);
    }

    TreeItem(Tree parent, TreeItem parentItem, int style, int index, int handle) {
        super(parent, style);
        this.parent = parent;
        this.handle = handle;
        if (handle == 0) {
            parent.createItem(this, parentItem, index);
        } else {
            this.createWidget();
        }
    }

    static Tree checkNull(Tree tree) {
        if (tree == null) {
            SWT.error(4);
        }
        return tree;
    }

    static TreeItem checkNull(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        int row;
        this.text = "";
        this.image = null;
        this.images = null;
        this.grayed = false;
        this.checked = false;
        this.updateCheckState(false);
        if (this.stringList != 0) {
            OS.GCHandle_Free(this.stringList);
        }
        this.stringList = 0;
        if (this.imageList != 0) {
            OS.GCHandle_Free(this.imageList);
        }
        this.imageList = 0;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
        if (this.ignoreNotify) {
            return;
        }
        if (this.parent.columnCount == 0) {
            row = OS.HeaderedItemsControl_Header(this.handle);
        } else {
            int header = OS.HeaderedItemsControl_Header(this.handle);
            row = OS.GridViewRowPresenter_Content(header);
            OS.GCHandle_Free(header);
        }
        OS.SWTRow_NotifyPropertyChanged(row, 0);
        OS.SWTRow_NotifyPropertyChanged(row, 1);
        OS.GCHandle_Free(row);
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            SWT.error(6);
        }
        this.parent.clear(this.handle, index, all);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.parent.clearAll(this, all);
    }

    void columnAdded(int index) {
        if (this.parent.columnCount == 0) {
            int headerTemplate = OS.HeaderedItemsControl_HeaderTemplateProperty();
            OS.DependencyObject_ClearValue(this.handle, headerTemplate);
            OS.GCHandle_Free(headerTemplate);
            int row = OS.HeaderedItemsControl_Header(this.handle);
            int header = OS.gcnew_SWTTreeViewRowPresenter(this.parent.handle);
            if (header == 0) {
                this.error(2);
            }
            OS.GridViewRowPresenterBase_Columns(header, this.parent.columns);
            OS.HeaderedItemsControl_Header(this.handle, header);
            OS.GridViewRowPresenter_Content(header, row);
            OS.GCHandle_Free(header);
            OS.GCHandle_Free(row);
        } else {
            int newLength = this.parent.columnCount + 1;
            if (this.images != null) {
                Image[] temp = new Image[newLength];
                System.arraycopy(this.images, 0, temp, 0, index);
                System.arraycopy(this.images, index, temp, index + 1, this.parent.columnCount - index);
                this.images = temp;
            }
            OS.ArrayList_Insert(this.stringList, index, 0);
            if (this.imageList != 0) {
                OS.ArrayList_Insert(this.imageList, index, 0);
            }
        }
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.parent.getItem(items, i, false);
            if (item != null) {
                item.columnAdded(index);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
    }

    void columnRemoved(int index) {
        if (this.parent.columnCount == 0) {
            int header = OS.HeaderedItemsControl_Header(this.handle);
            int row = OS.GridViewRowPresenter_Content(header);
            OS.TreeViewItem_HeaderTemplate(this.handle, this.parent.headerTemplate);
            OS.HeaderedItemsControl_Header(this.handle, row);
            OS.GCHandle_Free(header);
            OS.GCHandle_Free(row);
        } else {
            if (this.images != null) {
                Image[] temp = new Image[this.parent.columnCount];
                System.arraycopy(this.images, 0, temp, 0, index);
                System.arraycopy(this.images, index + 1, temp, index, this.parent.columnCount - index);
                this.images = temp;
            }
            if (this.parent.columnCount != 0) {
                OS.ArrayList_RemoveAt(this.stringList, index);
                if (this.imageList != 0) {
                    OS.ArrayList_RemoveAt(this.imageList, index);
                }
            }
        }
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.parent.getItem(items, i, false);
            if (item != null) {
                item.columnRemoved(index);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
    }

    void createHandle() {
        if (this.handle == 0) {
            this.handle = OS.gcnew_TreeViewItem();
            if (this.handle == 0) {
                this.error(2);
            }
            if (this.parent.columnCount != 0) {
                int headerHandle = OS.gcnew_SWTTreeViewRowPresenter(this.parent.handle);
                if (headerHandle == 0) {
                    this.error(2);
                }
                OS.GridViewRowPresenterBase_Columns(headerHandle, this.parent.columns);
                OS.HeaderedItemsControl_Header(this.handle, headerHandle);
                int row = OS.gcnew_SWTRow(this.parent.jniRef, this.handle);
                OS.GridViewRowPresenter_Content(headerHandle, row);
                OS.GCHandle_Free(headerHandle);
                OS.GCHandle_Free(row);
            } else {
                int row = OS.gcnew_SWTRow(this.parent.jniRef, this.handle);
                OS.HeaderedItemsControl_Header(this.handle, row);
                OS.GCHandle_Free(row);
                OS.TreeViewItem_HeaderTemplate(this.handle, this.parent.headerTemplate);
            }
        }
        OS.Control_HorizontalContentAlignment(this.handle, 3);
        OS.Control_VerticalContentAlignment(this.handle, 3);
        this.updateCheckState(false);
    }

    void deregister() {
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    int findContentPresenter(int element, int column) {
        int contentPresenter;
        int controlTemplate = OS.Control_Template(this.handle);
        int headerName = this.createDotNetString("PART_Header", false);
        int partHeader = OS.FrameworkTemplate_FindName(controlTemplate, headerName, this.handle);
        if (this.parent.columnCount == 0) {
            contentPresenter = partHeader;
        } else {
            int rowPresenter = OS.VisualTreeHelper_GetChild(partHeader, 0);
            contentPresenter = OS.VisualTreeHelper_GetChild(rowPresenter, column);
            OS.GCHandle_Free(rowPresenter);
            OS.GCHandle_Free(partHeader);
        }
        OS.GCHandle_Free(headerName);
        OS.GCHandle_Free(controlTemplate);
        return contentPresenter;
    }

    int findPart(int column, String part) {
        int cellTemplate;
        this.updateLayout(this.handle);
        if (OS.UIElement_Visibility(this.handle) != 0) {
            return 0;
        }
        int contentPresenter = this.findContentPresenter(this.handle, column);
        if (this.parent.columnCount != 0) {
            int columnHandle = OS.GridViewColumnCollection_default(this.parent.columns, column);
            cellTemplate = OS.GridViewColumn_CellTemplate(columnHandle);
            OS.GCHandle_Free(columnHandle);
        } else {
            cellTemplate = OS.TreeViewItem_HeaderTemplate(this.handle);
        }
        int name = this.createDotNetString(part, false);
        int result = OS.FrameworkTemplate_FindName(cellTemplate, name, contentPresenter);
        if (name != 0) {
            OS.GCHandle_Free(name);
        }
        OS.GCHandle_Free(cellTemplate);
        OS.GCHandle_Free(contentPresenter);
        return result;
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.parent.getBackground();
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.parent.getBackground();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (!OS.UIElement_IsVisible(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int point = OS.gcnew_Point(0.0, 0.0);
        int location = OS.UIElement_TranslatePoint(this.handle, point, this.parent.handle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        int width = (int)OS.FrameworkElement_ActualWidth(this.handle);
        int height = (int)OS.FrameworkElement_ActualHeight(this.handle);
        return new Rectangle(x, y, width, height);
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index != 0 && (index < 0 || index >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (!OS.UIElement_IsVisible(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        this.updateLayout(this.handle);
        int point = OS.gcnew_Point(0.0, 0.0);
        int contentPresenter = this.findContentPresenter(this.handle, index);
        int location = OS.UIElement_TranslatePoint(contentPresenter, point, this.parent.handle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        int width = (int)OS.FrameworkElement_ActualWidth(contentPresenter);
        int height = (int)OS.FrameworkElement_ActualHeight(contentPresenter);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        OS.GCHandle_Free(contentPresenter);
        return new Rectangle(x, y, width, height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return OS.TreeViewItem_IsExpanded(this.handle);
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.parent.getFont();
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.parent.getForeground();
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.parent.getForeground();
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return false;
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int items = OS.ItemsControl_Items(this.handle);
        TreeItem item = this.parent.getItem(items, index, true);
        OS.GCHandle_Free(items);
        return item;
    }

    public int getItemCount() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.itemCount;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int items = OS.ItemsControl_Items(this.handle);
        TreeItem[] result = new TreeItem[this.itemCount];
        int i = 0;
        while (i < result.length) {
            result[i] = this.parent.getItem(items, i, true);
            ++i;
        }
        OS.GCHandle_Free(items);
        return result;
    }

    public Image getImage() {
        this.checkWidget();
        return this.getImage(0);
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (this.images != null && index >= 0 && index < this.images.length) {
            return this.images[index];
        }
        return null;
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index != 0 && (index < 0 || index >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int parentHandle = this.parent.topHandle();
        int part = this.findPart(index, "SWT_PART_IMAGE");
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int location = OS.UIElement_TranslatePoint(part, point, parentHandle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        int width = (int)OS.FrameworkElement_ActualWidth(part);
        int height = (int)OS.FrameworkElement_ActualHeight(part);
        OS.GCHandle_Free(part);
        return new Rectangle(x, y, width, height);
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        int parentItem = OS.FrameworkElement_Parent(this.handle);
        TreeItem result = null;
        if (!OS.Object_Equals(parentItem, this.parent.handle)) {
            result = (TreeItem)this.display.getWidget(parentItem);
        }
        OS.GCHandle_Free(parentItem);
        return result;
    }

    public Rectangle getTextBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index != 0 && (index < 0 || index >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int parentHandle = this.parent.topHandle();
        int part = this.findPart(index, "SWT_PART_TEXT");
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int location = OS.UIElement_TranslatePoint(part, point, parentHandle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        int width = (int)OS.FrameworkElement_ActualWidth(part);
        int height = (int)OS.FrameworkElement_ActualHeight(part);
        OS.GCHandle_Free(part);
        return new Rectangle(x, y, width, height);
    }

    public String getText() {
        this.checkWidget();
        return this.getText(0);
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (this.stringList != 0 && index >= 0 && index < OS.ArrayList_Count(this.stringList)) {
            int ptr = OS.ArrayList_default(this.stringList, index);
            String result = TreeItem.createJavaString(ptr);
            OS.GCHandle_Free(ptr);
            return result;
        }
        return "";
    }

    Control getWidgetControl() {
        return this.parent;
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int items = OS.ItemsControl_Items(this.handle);
        int index = OS.ItemCollection_IndexOf(items, item.handle);
        OS.GCHandle_Free(items);
        return index;
    }

    void register() {
        this.display.addWidget(this.handle, this);
    }

    void releaseChildren(boolean destroy) {
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.parent.getItem(items, i, false);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if ((this.parent.style & 2) != 0) {
            this.parent.removeSelectedItem(this);
        }
        if (this.imageList != 0) {
            OS.GCHandle_Free(this.imageList);
        }
        this.imageList = 0;
        if (this.stringList != 0) {
            OS.GCHandle_Free(this.stringList);
        }
        this.stringList = 0;
        if (this.checkState != 0) {
            OS.GCHandle_Free(this.checkState);
        }
        this.checkState = 0;
        this.images = null;
    }

    public void removeAll() {
        this.checkWidget();
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.parent.getItem(items, i, false);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        this.parent.ignoreSelection = true;
        OS.ItemCollection_Clear(items);
        this.parent.ignoreSelection = false;
        OS.GCHandle_Free(items);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == checked) {
            return;
        }
        this.checked = checked;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.updateCheckState(true);
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        OS.TreeViewItem_IsExpanded(this.handle, expanded);
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == grayed) {
            return;
        }
        this.grayed = grayed;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.updateCheckState(true);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setImage(int index, Image image) {
        int row;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.images == null) {
            this.images = new Image[count];
        }
        this.images[index] = image;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.imageList == 0) {
            this.imageList = OS.gcnew_ArrayList(count);
            int i = 0;
            while (i < count) {
                OS.ArrayList_Insert(this.imageList, i, 0);
                ++i;
            }
        }
        int imageHandle = image != null ? image.handle : 0;
        OS.ArrayList_default(this.imageList, index, imageHandle);
        if (this.ignoreNotify) {
            return;
        }
        if (this.parent.columnCount != 0) {
            int header = OS.HeaderedItemsControl_Header(this.handle);
            row = OS.GridViewRowPresenter_Content(header);
            OS.GCHandle_Free(header);
        } else {
            row = OS.HeaderedItemsControl_Header(this.handle);
        }
        OS.SWTRow_NotifyPropertyChanged(row, 1);
        OS.GCHandle_Free(row);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setItemCount(int count) {
        this.checkWidget();
        this.parent.setItemCount(this, count);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }

    public void setText(int index, String string) {
        int row;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.stringList == 0) {
            this.stringList = OS.gcnew_ArrayList(count);
            int i = 0;
            while (i < count) {
                OS.ArrayList_Insert(this.stringList, i, 0);
                ++i;
            }
        }
        int str = this.createDotNetString(string, false);
        OS.ArrayList_default(this.stringList, index, str);
        OS.GCHandle_Free(str);
        if (this.ignoreNotify) {
            return;
        }
        if (this.parent.columnCount != 0) {
            int header = OS.HeaderedItemsControl_Header(this.handle);
            row = OS.GridViewRowPresenter_Content(header);
            OS.GCHandle_Free(header);
        } else {
            row = OS.HeaderedItemsControl_Header(this.handle);
        }
        OS.SWTRow_NotifyPropertyChanged(row, 0);
        OS.GCHandle_Free(row);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    void updateCheckState(boolean notify) {
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checkState != 0) {
            OS.GCHandle_Free(this.checkState);
        }
        this.checkState = this.checked ? (this.grayed ? OS.gcnew_IntPtr(2) : OS.gcnew_IntPtr(1)) : OS.gcnew_IntPtr(0);
        if (notify) {
            int row;
            if (this.parent.columnCount != 0) {
                int header = OS.HeaderedItemsControl_Header(this.handle);
                row = OS.GridViewRowPresenter_Content(header);
                OS.GCHandle_Free(header);
            } else {
                row = OS.HeaderedItemsControl_Header(this.handle);
            }
            this.parent.ignoreSelection = true;
            OS.SWTRow_NotifyPropertyChanged(row, 4);
            this.parent.ignoreSelection = false;
            OS.GCHandle_Free(row);
        }
    }
}

