/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    Point[] offsets;
    Point selection;
    String[] ids;
    String text;
    private int[] mnemonics;

    public Link(Composite parent, int style) {
        super(parent, style);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int backgroundProperty() {
        return OS.TextBlock_BackgroundProperty();
    }

    void createHandle() {
        this.state |= 0x100;
        this.handle = OS.gcnew_TextBlock();
        if (this.handle == 0) {
            this.error(2);
        }
    }

    int defaultBackground() {
        return OS.SystemColors_ControlColor;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    void HandleClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        int i = OS.FrameworkContentElement_Tag(source);
        OS.GCHandle_Free(source);
        Event event = new Event();
        event.text = this.ids[i];
        this.sendEvent(13, event);
    }

    String parse(String string) {
        int length = string.length();
        this.offsets = new Point[length / 4];
        this.ids = new String[length / 4];
        this.mnemonics = new int[length / 4 + 1];
        StringBuffer result = new StringBuffer();
        char[] buffer = new char[length];
        string.getChars(0, string.length(), buffer, 0);
        int index = 0;
        int state = 0;
        int linkIndex = 0;
        int start = 0;
        int tagStart = 0;
        int linkStart = 0;
        int endtagStart = 0;
        int refStart = 0;
        while (index < length) {
            char c = Character.toLowerCase(buffer[index]);
            block0 : switch (state) {
                case 0: {
                    if (c != '<') break;
                    tagStart = index;
                    ++state;
                    break;
                }
                case 1: {
                    if (c != 'a') break;
                    ++state;
                    break;
                }
                case 2: {
                    switch (c) {
                        case 'h': {
                            state = 7;
                            break block0;
                        }
                        case '>': {
                            linkStart = index + 1;
                            ++state;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(c)) break;
                    state = 13;
                    break;
                }
                case 3: {
                    if (c != '<') break;
                    endtagStart = index;
                    ++state;
                    break;
                }
                case 4: {
                    state = c == '/' ? state + 1 : 3;
                    break;
                }
                case 5: {
                    state = c == 'a' ? state + 1 : 3;
                    break;
                }
                case 6: {
                    if (c == '>') {
                        this.mnemonics[linkIndex] = this.parseMnemonics(buffer, start, tagStart, result);
                        int offset = result.length();
                        this.parseMnemonics(buffer, linkStart, endtagStart, result);
                        this.offsets[linkIndex] = new Point(offset, result.length() - 1);
                        if (this.ids[linkIndex] == null) {
                            this.ids[linkIndex] = new String(buffer, linkStart, endtagStart - linkStart);
                        }
                        ++linkIndex;
                        endtagStart = refStart = index + 1;
                        linkStart = refStart;
                        tagStart = refStart;
                        start = refStart;
                        state = 0;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 7: {
                    state = c == 'r' ? state + 1 : 0;
                    break;
                }
                case 8: {
                    state = c == 'e' ? state + 1 : 0;
                    break;
                }
                case 9: {
                    state = c == 'f' ? state + 1 : 0;
                    break;
                }
                case 10: {
                    state = c == '=' ? state + 1 : 0;
                    break;
                }
                case 11: {
                    if (c == '\"') {
                        ++state;
                        refStart = index + 1;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 12: {
                    if (c != '\"') break;
                    this.ids[linkIndex] = new String(buffer, refStart, index - refStart);
                    state = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace(c)) {
                        state = 0;
                        break;
                    }
                    if (c != '=') break;
                    ++state;
                    break;
                }
                case 14: {
                    state = c == '\"' ? state + 1 : 0;
                    break;
                }
                case 15: {
                    if (c != '\"') break;
                    state = 2;
                    break;
                }
                default: {
                    state = 0;
                }
            }
            ++index;
        }
        if (start < length) {
            int tmp = this.parseMnemonics(buffer, start, tagStart, result);
            int mnemonic = this.parseMnemonics(buffer, linkStart, index, result);
            if (mnemonic == -1) {
                mnemonic = tmp;
            }
            this.mnemonics[linkIndex] = mnemonic;
        } else {
            this.mnemonics[linkIndex] = -1;
        }
        if (this.offsets.length != linkIndex) {
            Point[] newOffsets = new Point[linkIndex];
            System.arraycopy(this.offsets, 0, newOffsets, 0, linkIndex);
            this.offsets = newOffsets;
            String[] newIDs = new String[linkIndex];
            System.arraycopy(this.ids, 0, newIDs, 0, linkIndex);
            this.ids = newIDs;
            int[] newMnemonics = new int[linkIndex + 1];
            System.arraycopy(this.mnemonics, 0, newMnemonics, 0, linkIndex + 1);
            this.mnemonics = newMnemonics;
        }
        return result.toString();
    }

    int parseMnemonics(char[] buffer, int start, int end, StringBuffer result) {
        int mnemonic = -1;
        int index = start;
        while (index < end) {
            if (buffer[index] == '&') {
                if (index + 1 < end && buffer[index + 1] == '&') {
                    result.append(buffer[index]);
                    ++index;
                } else {
                    mnemonic = result.length();
                }
            } else {
                result.append(buffer[index]);
            }
            ++index;
        }
        return mnemonic;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void setFont(int font, double size) {
        if (font != 0) {
            int fontFamily = OS.Typeface_FontFamily(font);
            int style = OS.Typeface_Style(font);
            int weight = OS.Typeface_Weight(font);
            int stretch = OS.Typeface_Stretch(font);
            OS.TextBlock_FontFamily(this.handle, fontFamily);
            OS.TextBlock_FontStyle(this.handle, style);
            OS.TextBlock_FontWeight(this.handle, weight);
            OS.TextBlock_FontStretch(this.handle, stretch);
            OS.TextBlock_FontSize(this.handle, size);
            OS.GCHandle_Free(fontFamily);
            OS.GCHandle_Free(style);
            OS.GCHandle_Free(weight);
            OS.GCHandle_Free(stretch);
        } else {
            int property = OS.TextBlock_FontFamilyProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.TextBlock_FontStyleProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.TextBlock_FontWeightProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.TextBlock_FontStretchProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.TextBlock_FontSizeProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
    }

    void setForegroundBrush(int brush) {
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        String parsed = this.parse(string);
        int inlines = OS.TextBlock_Inlines(this.handle);
        OS.InlineCollection_Clear(inlines);
        int start = 0;
        int end = parsed.length();
        int offsetIndex = 0;
        while (start < end) {
            int run;
            int stringPtr;
            String substring;
            Point point;
            Point point2 = point = offsetIndex < this.offsets.length ? this.offsets[offsetIndex] : null;
            if (point == null) {
                substring = parsed.substring(start, end);
                stringPtr = this.createDotNetString(substring, false);
                if (stringPtr == 0) {
                    this.error(2);
                }
                if ((run = OS.gcnew_Run()) == 0) {
                    this.error(2);
                }
                OS.Run_Text(run, stringPtr);
                OS.InlineCollection_Add(inlines, run);
                OS.GCHandle_Free(stringPtr);
                OS.GCHandle_Free(run);
                start = end;
                continue;
            }
            if (start < point.x) {
                substring = parsed.substring(start, point.x);
                stringPtr = this.createDotNetString(substring, false);
                if (stringPtr == 0) {
                    this.error(2);
                }
                if ((run = OS.gcnew_Run()) == 0) {
                    this.error(2);
                }
                OS.Run_Text(run, stringPtr);
                OS.InlineCollection_Add(inlines, run);
                OS.GCHandle_Free(stringPtr);
                OS.GCHandle_Free(run);
                start = point.x;
                continue;
            }
            substring = parsed.substring(point.x, point.y + 1);
            stringPtr = this.createDotNetString(substring, false);
            if (stringPtr == 0) {
                this.error(2);
            }
            if ((run = OS.gcnew_Run()) == 0) {
                this.error(2);
            }
            OS.Run_Text(run, stringPtr);
            int hyperlink = OS.gcnew_Hyperlink(run);
            OS.FrameworkContentElement_Tag(hyperlink, offsetIndex);
            OS.InlineCollection_Add(inlines, hyperlink);
            int handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleClick");
            OS.Hyperlink_Click(hyperlink, handler);
            OS.GCHandle_Free(handler);
            OS.GCHandle_Free(stringPtr);
            OS.GCHandle_Free(run);
            OS.GCHandle_Free(hyperlink);
            start = point.y + 1;
            ++offsetIndex;
        }
        OS.GCHandle_Free(inlines);
    }

    int traversalCode(int key, int event) {
        int bits = super.traversalCode(key, event);
        return bits;
    }
}

