/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;

public class TabFolder
extends Composite {
    int parentingHandle;
    int itemCount;
    Control[] children;
    int childCount;
    boolean ignoreSelection;

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
    }

    int backgroundProperty() {
        return OS.Control_BackgroundProperty();
    }

    void addChild(Control widget) {
        super.addChild(widget);
        if (this.childCount == this.children.length) {
            Control[] newChildren = new Control[this.childCount + 4];
            System.arraycopy(this.children, 0, newChildren, 0, this.childCount);
            this.children = newChildren;
        }
        this.children[this.childCount++] = widget;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        style = TabFolder.checkBits(style, 128, 1024, 0, 0, 0, 0);
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int clientHandle() {
        int index = OS.Selector_SelectedIndex(this.handle);
        if (index != -1) {
            int items = OS.ItemsControl_Items(this.handle);
            TabItem item = this.getItem(items, index);
            OS.GCHandle_Free(items);
            return item.contentHandle;
        }
        return this.handle;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        Point sizeTabFolder = this.computeSize(this.handle, wHint, hHint, changed);
        return new Point(Math.max(sizeTabFolder.x + 1, size.x + 10), size.y + sizeTabFolder.y + 10);
    }

    void createItem(TabItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        item.createWidget();
        int items = OS.ItemsControl_Items(this.handle);
        OS.ItemCollection_Insert(items, index, item.topHandle());
        int count = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        if (this.itemCount == count) {
            this.error(14);
        }
        ++this.itemCount;
    }

    void createHandle() {
        this.parentingHandle = OS.gcnew_Canvas();
        if (this.parentingHandle == 0) {
            this.error(2);
        }
        this.handle = OS.gcnew_TabControl();
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x400) != 0) {
            OS.TabControl_TabStripPlacement(this.handle, 3);
        }
        int children = OS.Panel_Children(this.parentingHandle);
        OS.UIElementCollection_Add(children, this.handle);
        OS.GCHandle_Free(children);
        OS.Canvas_SetLeft(this.handle, 0.0);
        OS.Canvas_SetTop(this.handle, 0.0);
    }

    void createWidget() {
        super.createWidget();
        this.children = new Control[4];
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.parentingHandle);
    }

    void destroyItem(TabItem item) {
        int items = OS.ItemsControl_Items(this.handle);
        OS.ItemCollection_Remove(items, item.topHandle());
        int count = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        if (this.itemCount == count) {
            this.error(15);
        }
        --this.itemCount;
    }

    Control findThemeControl() {
        return this;
    }

    Control[] _getChildren() {
        Control[] result = new Control[this.childCount];
        int i = 0;
        while (i < this.childCount) {
            result[this.childCount - i - 1] = this.children[i];
            ++i;
        }
        return result;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle rect = super.getClientArea();
        int clientHandle = this.clientHandle();
        int topHandle = this.topHandle();
        int point = OS.gcnew_Point(0.0, 0.0);
        int result = OS.UIElement_TranslatePoint(clientHandle, point, topHandle);
        rect.x = (int)OS.Point_X(result);
        rect.y = (int)OS.Point_Y(result);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(result);
        return rect;
    }

    public TabItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        int items = OS.ItemsControl_Items(this.handle);
        TabItem item = this.getItem(items, index);
        OS.GCHandle_Free(items);
        return item;
    }

    TabItem getItem(int items, int index) {
        int item = OS.ItemCollection_GetItemAt(items, index);
        TabItem result = (TabItem)this.display.getWidget(item);
        OS.GCHandle_Free(item);
        return result;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        TabItem[] result = new TabItem[this.itemCount];
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            result[i] = this.getItem(items, i);
            ++i;
        }
        OS.GCHandle_Free(items);
        return result;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int index = OS.Selector_SelectedIndex(this.handle);
        if (index == -1) {
            return new TabItem[0];
        }
        int items = OS.ItemsControl_Items(this.handle);
        TabItem item = this.getItem(items, index);
        OS.GCHandle_Free(items);
        return new TabItem[]{item};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.Selector_SelectedIndex(this.handle);
    }

    boolean hasItems() {
        return true;
    }

    void HandleSelectionChanged(int sender, int e) {
        Control control;
        TabItem item;
        if (!this.checkEvent(e)) {
            return;
        }
        int removed = OS.SelectionChangedEventArgs_RemovedItems(e);
        if (OS.ICollection_Count(removed) > 0) {
            int oldSelection = OS.IList_default(removed, 0);
            item = (TabItem)this.display.getWidget(oldSelection);
            OS.GCHandle_Free(oldSelection);
            control = item.getControl();
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        }
        OS.GCHandle_Free(removed);
        int selectedItem = OS.Selector_SelectedItem(this.handle);
        if (selectedItem == 0) {
            return;
        }
        item = (TabItem)this.display.getWidget(selectedItem);
        OS.GCHandle_Free(selectedItem);
        control = item.getControl();
        if (control != null && !control.isDisposed()) {
            control.setVisible(true);
        }
        if (this.ignoreSelection) {
            return;
        }
        Event event = new Event();
        event.item = item;
        this.postEvent(13, event);
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_SelectionChangedEventHandler(this.jniRef, "HandleSelectionChanged");
        OS.Selector_SelectionChanged(this.handle, handler);
        OS.GCHandle_Free(handler);
    }

    public int indexOf(TabItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int items = OS.ItemsControl_Items(this.handle);
        int index = OS.ItemCollection_IndexOf(items, item.topHandle());
        OS.GCHandle_Free(items);
        return index;
    }

    Point minimumSize(int wHint, int hHint, boolean flushCache) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            int index = 0;
            while (index < this.itemCount) {
                TabItem item = this.getItem(items, index);
                if (item.control == child) break;
                ++index;
            }
            if (index == this.itemCount) {
                Rectangle rect = child.getBounds();
                width = Math.max(width, rect.x + rect.width);
                height = Math.max(height, rect.y + rect.height);
            } else {
                Point size = child.computeSize(wHint, hHint, flushCache);
                width = Math.max(width, size.x);
                height = Math.max(height, size.y);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
        return new Point(width, height);
    }

    boolean mnemonicHit(char key) {
        return false;
    }

    boolean mnemonicMatch(char key) {
        boolean found = false;
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TabItem item = this.getItem(items, i);
            if (this.mnemonicMatch(item.textHandle, key)) {
                found = true;
                break;
            }
            ++i;
        }
        OS.GCHandle_Free(items);
        return found;
    }

    int parentingHandle() {
        return this.parentingHandle;
    }

    void register() {
        super.register();
        this.display.addWidget(this.parentingHandle, this);
    }

    void releaseChildren(boolean destroy) {
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TabItem item = this.getItem(items, i);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
        super.releaseChildren(destroy);
    }

    void removeChild(Control control) {
        super.removeChild(control);
        int index = 0;
        while (index < this.childCount) {
            if (this.children[index] == control) break;
            ++index;
        }
        if (index == this.childCount) {
            return;
        }
        System.arraycopy(this.children, index + 1, this.children, index, --this.childCount - index);
        this.children[this.childCount] = null;
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.parentingHandle != 0) {
            OS.GCHandle_Free(this.parentingHandle);
        }
        this.parentingHandle = 0;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TabItem item = this.getItem(items, i);
            if (item.control == control) {
                item.setControl(null);
                break;
            }
            ++i;
        }
        OS.GCHandle_Free(items);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    int setBounds(int x, int y, int width, int height, int flags) {
        int result = super.setBounds(x, y, width, height, flags);
        if ((result & 0x4000) != 0) {
            OS.FrameworkElement_Height(this.handle, height);
            OS.FrameworkElement_Width(this.handle, width);
            int selectedItem = OS.Selector_SelectedItem(this.handle);
            if (selectedItem != 0) {
                TabItem item = (TabItem)this.display.getWidget(selectedItem);
                OS.GCHandle_Free(selectedItem);
                Control control = item.control;
                if (control != null && !control.isDisposed()) {
                    control.setBounds(this.getClientArea());
                }
            }
        }
        return result;
    }

    void setForegroundBrush(int brush) {
        if (brush != 0) {
            OS.Control_Foreground(this.handle, brush);
        } else {
            int property = OS.Control_ForegroundProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
    }

    public void setSelection(TabItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{item});
    }

    public void setSelection(TabItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if (items.length == 0) {
            this.setSelection(-1, false);
        } else {
            int i = items.length - 1;
            while (i >= 0) {
                int index = this.indexOf(items[i]);
                if (index != -1) {
                    this.setSelection(index, false);
                }
                --i;
            }
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        this.setSelection(index, false);
    }

    void setSelection(int index, boolean notify) {
        int oldIndex = OS.Selector_SelectedIndex(this.handle);
        if (oldIndex != -1) {
            int items = OS.ItemsControl_Items(this.handle);
            TabItem item = this.getItem(items, oldIndex);
            OS.GCHandle_Free(items);
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        }
        this.ignoreSelection = true;
        OS.Selector_SelectedIndex(this.handle, index);
        this.ignoreSelection = false;
        int newIndex = OS.Selector_SelectedIndex(this.handle);
        if (newIndex != -1) {
            int items = OS.ItemsControl_Items(this.handle);
            TabItem item = this.getItem(items, newIndex);
            OS.GCHandle_Free(items);
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(true);
            }
            if (notify) {
                Event event = new Event();
                event.item = item;
                this.sendEvent(13, event);
            }
        }
    }

    int topHandle() {
        return this.parentingHandle;
    }

    boolean traversePage(boolean next) {
        int count = this.getItemCount();
        if (count <= 1) {
            return false;
        }
        int index = this.getSelectionIndex();
        if (index == -1) {
            index = 0;
        } else {
            int offset = next ? 1 : -1;
            index = (index + offset + count) % count;
        }
        this.setSelection(index, true);
        return index == this.getSelectionIndex();
    }
}

