/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    boolean doubleClick;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\r\n";

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 0x400000) != 0) {
            return;
        }
        int strPtr = this.createDotNetString(string, false);
        OS.TextBoxBase_AppendText(this.handle, strPtr);
        OS.TextBoxBase_ScrollToEnd(this.handle);
        OS.GCHandle_Free(strPtr);
    }

    static int checkStyle(int style) {
        if ((style & 0x80) != 0) {
            style |= 0x804;
            style &= 0xFFBFFFFF;
        }
        if (((style &= 0xFFFFFF7F) & 4) != 0 && (style & 2) != 0) {
            style &= 0xFFFFFFFD;
        }
        if (((style = Text.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
            style &= 0xFFFFFEFF;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 0x400000) != 0) {
            OS.TextBox_SelectionLength(this.handle, 0);
        }
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 0x400000) != 0) {
            OS.TextBoxBase_Copy(this.handle);
        }
    }

    void createHandle() {
        if ((this.style & 0x400000) != 0) {
            this.handle = OS.gcnew_PasswordBox();
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        this.handle = OS.gcnew_TextBox();
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 2) != 0) {
            OS.TextBoxBase_AcceptsReturn(this.handle, true);
            OS.TextBoxBase_AcceptsTab(this.handle, true);
            if ((this.style & 0x40) != 0) {
                OS.TextBox_TextWrapping(this.handle, 2);
            }
        }
        if ((this.style & 0x800) == 0) {
            int thickness = OS.gcnew_Thickness(0.0, 0.0, 0.0, 0.0);
            OS.Control_BorderThickness(this.handle, thickness);
            OS.Control_Padding(this.handle, thickness);
            OS.GCHandle_Free(thickness);
        }
        if ((this.style & 8) != 0) {
            OS.TextBoxBase_IsReadOnly(this.handle, true);
        }
        if ((this.style & 0x1000000) != 0) {
            OS.Control_HorizontalContentAlignment(this.handle, 1);
        }
        if ((this.style & 0x20000) != 0) {
            OS.Control_HorizontalContentAlignment(this.handle, 2);
        }
        if ((this.style & 0x200) != 0) {
            OS.TextBoxBase_VerticalScrollBarVisibility(this.handle, 3);
        }
        if ((this.style & 0x100) != 0) {
            OS.TextBoxBase_HorizontalScrollBarVisibility(this.handle, 3);
        }
    }

    void createWidget() {
        super.createWidget();
        this.doubleClick = true;
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        if ((this.style & 0x400000) != 0) {
            return;
        }
        OS.TextBoxBase_Cut(this.handle);
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        if ((this.style & 0x400000) != 0) {
            return 0;
        }
        int caretIndex = OS.TextBox_CaretIndex(this.handle);
        return OS.TextBox_GetLineIndexFromCharacterIndex(this.handle, caretIndex);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        if ((this.style & 0x400000) != 0) {
            return new Point(0, 0);
        }
        int caretIndex = OS.TextBox_CaretIndex(this.handle);
        int rect = OS.TextBox_GetRectFromCharacterIndex(this.handle, caretIndex);
        Point result = new Point((int)OS.Rect_X(rect), (int)OS.Rect_Y(rect));
        OS.GCHandle_Free(rect);
        return result;
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 0x400000) != 0) {
            return 0;
        }
        return OS.TextBox_CaretIndex(this.handle);
    }

    public int getCharCount() {
        this.checkWidget();
        int text = (this.style & 0x400000) != 0 ? OS.PasswordBox_Password(this.handle) : OS.TextBox_Text(this.handle);
        int length = OS.String_Length(text);
        OS.GCHandle_Free(text);
        return length;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        if ((this.style & 0x400000) == 0) {
            return '\u0000';
        }
        return OS.PasswordBox_PasswordChar(this.handle);
    }

    public boolean getEditable() {
        this.checkWidget();
        if ((this.style & 0x400000) != 0) {
            return true;
        }
        return OS.TextBoxBase_IsReadOnly(this.handle);
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 0x400000) != 0) {
            return 1;
        }
        return OS.TextBox_LineCount(this.handle);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        this.checkWidget();
        return 10;
    }

    public String getMessage() {
        this.checkWidget();
        return "";
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 0x400000) != 0) {
            return new Point(0, 0);
        }
        int start = OS.TextBox_SelectionStart(this.handle);
        int length = OS.TextBox_SelectionLength(this.handle);
        return new Point(start, start + length);
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point selection = this.getSelection();
        return selection.y - selection.x;
    }

    public String getSelectionText() {
        this.checkWidget();
        if ((this.style & 0x400000) != 0) {
            return "";
        }
        int content = OS.TextBox_SelectedText(this.handle);
        String string = Text.createJavaString(content);
        OS.GCHandle_Free(content);
        return string;
    }

    public int getTabs() {
        this.checkWidget();
        return 8;
    }

    public String getText() {
        this.checkWidget();
        int text = (this.style & 0x400000) != 0 ? OS.PasswordBox_Password(this.handle) : OS.TextBox_Text(this.handle);
        String string = Text.createJavaString(text);
        OS.GCHandle_Free(text);
        return string;
    }

    public String getText(int start, int end) {
        this.checkWidget();
        if (start > end || end < 0) {
            return "";
        }
        String text = this.getText();
        int length = text.length();
        start = Math.max(0, start);
        end = Math.min(end, length - 1);
        return text.substring(start, end + 1);
    }

    public int getTextLimit() {
        this.checkWidget();
        if ((this.style & 0x400000) != 0) {
            return OS.PasswordBox_MaxLength(this.handle);
        }
        return OS.TextBox_MaxLength(this.handle);
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        if ((this.style & 0x400000) != 0) {
            return 0;
        }
        return OS.TextBox_GetFirstVisibleLineIndex(this.handle);
    }

    public int getTopPixel() {
        this.checkWidget();
        return 0;
    }

    void HandlePreviewKeyDown(int sender, int e) {
        int key;
        super.HandlePreviewKeyDown(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        if ((this.style & 4) != 0 && (key = OS.KeyEventArgs_Key(e)) == 6) {
            this.postEvent(14);
        }
    }

    void HandlePreviewExecutedRoutedEvent(int sender, int e) {
        int end;
        if (!this.checkEvent(e)) {
            return;
        }
        int command = OS.ExecutedRoutedEventArgs_Command(e);
        boolean doVerify = false;
        String input = null;
        int paste = OS.ApplicationCommands_Paste();
        int cut = OS.ApplicationCommands_Cut();
        int redo = OS.ApplicationCommands_Redo();
        int undo = OS.ApplicationCommands_Undo();
        int backspace = OS.EditingCommands_Backspace();
        int delete = OS.EditingCommands_Delete();
        int deleteNext = OS.EditingCommands_DeleteNextWord();
        int deletePrevious = OS.EditingCommands_DeletePreviousWord();
        if (OS.Object_Equals(command, paste)) {
            doVerify = true;
            int clipboardText = OS.Clipboard_GetText();
            input = Text.createJavaString(clipboardText);
            OS.GCHandle_Free(clipboardText);
        } else if (OS.Object_Equals(command, cut)) {
            doVerify = true;
            input = this.getSelectionText();
        } else if (OS.Object_Equals(command, redo)) {
            OS.ExecutedRoutedEventArgs_Handled(e, true);
        } else if (OS.Object_Equals(command, undo)) {
            OS.ExecutedRoutedEventArgs_Handled(e, true);
        } else if (OS.Object_Equals(command, backspace)) {
            doVerify = true;
            input = "";
        } else if (OS.Object_Equals(command, delete)) {
            doVerify = true;
            input = "";
        } else if (OS.Object_Equals(command, deleteNext)) {
            OS.ExecutedRoutedEventArgs_Handled(e, true);
        } else if (OS.Object_Equals(command, deletePrevious)) {
            OS.ExecutedRoutedEventArgs_Handled(e, true);
        }
        OS.GCHandle_Free(paste);
        OS.GCHandle_Free(cut);
        OS.GCHandle_Free(redo);
        OS.GCHandle_Free(undo);
        OS.GCHandle_Free(backspace);
        OS.GCHandle_Free(delete);
        OS.GCHandle_Free(deleteNext);
        OS.GCHandle_Free(deletePrevious);
        OS.GCHandle_Free(command);
        if (!this.hooks(25)) {
            return;
        }
        if (!doVerify) {
            return;
        }
        int start = OS.TextBox_SelectionStart(this.handle);
        String text = this.verifyText(input, start, end = start + OS.TextBox_SelectionLength(this.handle), true);
        if (text != null && !text.equals(input)) {
            int strPtr = this.createDotNetString(text, false);
            OS.TextBox_SelectedText(this.handle, strPtr);
            OS.GCHandle_Free(strPtr);
            start = OS.TextBox_SelectionStart(this.handle);
            int length = OS.TextBox_SelectionLength(this.handle);
            OS.TextBox_Select(this.handle, start + length, 0);
            OS.TextBox_SelectionLength(this.handle, 0);
            text = null;
        }
        if (text == null) {
            OS.ExecutedRoutedEventArgs_Handled(e, true);
        }
    }

    void HandlePreviewTextInput(int sender, int e) {
        super.HandlePreviewTextInput(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        if ((this.style & 0x400000) != 0) {
            return;
        }
        int textPtr = OS.TextCompositionEventArgs_Text(e);
        String input = Text.createJavaString(textPtr);
        OS.GCHandle_Free(textPtr);
        int start = OS.TextBox_SelectionStart(this.handle);
        int end = start + OS.TextBox_SelectionLength(this.handle);
        String text = this.verifyText(input, start, end, true);
        if (text != null && !text.equals(input)) {
            textPtr = this.createDotNetString(text, false);
            OS.TextBox_SelectedText(this.handle, textPtr);
            OS.GCHandle_Free(textPtr);
            start = OS.TextBox_SelectionStart(this.handle);
            int length = OS.TextBox_SelectionLength(this.handle);
            OS.TextBox_Select(this.handle, start + length, 0);
            OS.TextBox_SelectionLength(this.handle, 0);
            text = null;
        }
        if (text == null) {
            OS.TextCompositionEventArgs_Handled(e, true);
        }
    }

    void HandleTextChanged(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.sendEvent(24);
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 0x400000) != 0) {
            int handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleTextChanged");
            if (handler == 0) {
                this.error(2);
            }
            OS.PasswordBox_PasswordChanged(this.handle, handler);
            OS.GCHandle_Free(handler);
            return;
        }
        int handler = OS.gcnew_ExecutedRoutedEventHandler(this.jniRef, "HandlePreviewExecutedRoutedEvent");
        if (handler == 0) {
            this.error(2);
        }
        OS.CommandManager_AddPreviewExecutedHandler(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_TextChangedEventHandler(this.jniRef, "HandleTextChanged");
        if (handler == 0) {
            this.error(2);
        }
        OS.TextBoxBase_TextChanged(this.handle, handler);
        OS.GCHandle_Free(handler);
    }

    public void insert(String string) {
        int end;
        int start;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 0x400000) != 0) {
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, start = OS.TextBox_SelectionStart(this.handle), end = start + OS.TextBox_SelectionLength(this.handle), false)) == null) {
            return;
        }
        int strPtr = this.createDotNetString(string, false);
        OS.TextBox_SelectedText(this.handle, strPtr);
        OS.GCHandle_Free(strPtr);
        end = OS.TextBox_SelectionStart(this.handle) + OS.TextBox_SelectionLength(this.handle);
        OS.TextBox_Select(this.handle, end, 0);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            OS.PasswordBox_Paste(this.handle);
            return;
        }
        OS.TextBoxBase_Paste(this.handle);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 0x400000) != 0) {
            return;
        }
        OS.TextBoxBase_SelectAll(this.handle);
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
        this.doubleClick = doubleClick;
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        if ((this.style & 0x400000) == 0) {
            return;
        }
        OS.PasswordBox_PasswordChar(this.handle, echo);
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!editable) {
            this.style |= 8;
        }
        if ((this.style & 0x400000) != 0) {
            return;
        }
        OS.TextBoxBase_IsReadOnly(this.handle, !editable);
    }

    void setFont(int font, double size) {
        super.setFont(font, size);
    }

    public void setMessage(String message) {
        this.checkWidget();
        if (message == null) {
            this.error(4);
        }
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        int flags = 0x6000000;
        if ((orientation & flags) == 0 || (orientation & flags) == flags) {
            return;
        }
        this.style &= ~flags;
        this.style |= orientation & flags;
    }

    public void setSelection(int start) {
        this.checkWidget();
        if ((this.style & 0x400000) != 0) {
            return;
        }
        OS.TextBox_CaretIndex(this.handle, start);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if ((this.style & 0x400000) != 0) {
            return;
        }
        int first = Math.max(Math.min(start, end), 0);
        int last = Math.min(Math.max(start, end), this.getCharCount());
        OS.TextBox_Select(this.handle, first, last - first);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        if (tabs < 0) {
            return;
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), false)) == null) {
            return;
        }
        int ptr = this.createDotNetString(string, false);
        if ((this.style & 0x400000) != 0) {
            OS.PasswordBox_Password(this.handle, ptr);
        } else {
            OS.TextBox_Text(this.handle, ptr);
        }
        OS.GCHandle_Free(ptr);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        if (limit < 0) {
            limit = LIMIT;
        }
        limit = Math.min(limit, LIMIT);
        if ((this.style & 0x400000) != 0) {
            OS.PasswordBox_MaxLength(this.handle, limit);
        } else {
            OS.TextBox_MaxLength(this.handle, limit);
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if ((this.style & 0x400000) != 0) {
            return;
        }
        int count = OS.TextBox_LineCount(this.handle);
        index = Math.min(Math.max(index, 0), count - 1);
        int topIndex = OS.TextBox_GetFirstVisibleLineIndex(this.handle);
        OS.TextBox_ScrollToLine(this.handle, index - topIndex);
    }

    public void showSelection() {
        this.checkWidget();
        if ((this.style & 0x400000) != 0) {
            return;
        }
        double offset = OS.TextBoxBase_VerticalOffset(this.handle);
        OS.TextBoxBase_ScrollToVerticalOffset(this.handle, offset);
    }

    int traversalCode(int key, int event) {
        int bits = super.traversalCode(key, event);
        if ((this.style & 8) != 0) {
            return bits;
        }
        if ((this.style & 2) != 0) {
            bits &= 0xFFFFFFFB;
            if (key == 3 && event != 0) {
                boolean next;
                int keyboardDevice = OS.KeyboardEventArgs_KeyboardDevice(event);
                int modifiers = OS.KeyboardDevice_Modifiers(keyboardDevice);
                OS.GCHandle_Free(keyboardDevice);
                boolean bl = next = (modifiers & 4) == 0;
                if (next && (modifiers & 2) == 0) {
                    bits &= 0xFFFFFFE7;
                }
            }
        }
        return bits;
    }

    String verifyText(String string, int start, int end, boolean keyEvent) {
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        if (keyEvent && string.length() == 1) {
            event.character = string.charAt(0);
            this.setInputState(event, 1, 0, 0);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

