/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.pcp.ui.swing;

import java.awt.Component;
import java.io.FileReader;
import java.util.Random;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jp.sourceforge.talisman.pcp.Metrics;
import jp.sourceforge.talisman.pcp.Sample;
import jp.sourceforge.talisman.pcp.Samples;
import jp.sourceforge.talisman.pcp.io.SamplesParser;
import jp.sourceforge.talisman.pcp.ui.swing.PcpPane;
import jp.sourceforge.talisman.pcp.ui.swing.actions.ActiveLineColorSelectAction;
import jp.sourceforge.talisman.pcp.ui.swing.actions.DotPlotAction;
import jp.sourceforge.talisman.pcp.ui.swing.actions.InactiveLineColorSelectAction;
import jp.sourceforge.talisman.pcp.ui.swing.actions.MissingValueAreaShowAction;
import jp.sourceforge.talisman.pcp.ui.swing.actions.SelectedAreaColorSelectAction;
import jp.sourceforge.talisman.pcp.ui.swing.actions.SelectionClearAction;

public class ExampleView {
    private ExampleView(String[] args) throws Exception {
        Samples samples;
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(2);
        if (args.length == 0) {
            samples = this.generateSamples();
        } else {
            SamplesParser parser = new SamplesParser();
            samples = parser.parse(new FileReader(args[0]));
        }
        PcpPane pcpPane = new PcpPane(samples);
        f.getContentPane().add((Component)this.createNorthPane(f, pcpPane), "North");
        f.getContentPane().add((Component)pcpPane, "Center");
        f.pack();
        f.setVisible(true);
    }

    private JComponent createNorthPane(JFrame f, PcpPane pcp) {
        JCheckBox dotplot = new JCheckBox(new DotPlotAction(pcp));
        JCheckBox showMissingValueArea = new JCheckBox(new MissingValueAreaShowAction(pcp));
        JButton activeLineColor = new JButton(new ActiveLineColorSelectAction(pcp));
        JButton inactiveLineColor = new JButton(new InactiveLineColorSelectAction(pcp));
        JButton selectionAreaColor = new JButton(new SelectedAreaColorSelectAction(pcp));
        JButton clearSelection = new JButton(new SelectionClearAction(pcp));
        dotplot.setSelected(pcp.getSetting().isDotPlot());
        showMissingValueArea.setSelected(pcp.getSetting().isShowMissingValueArea());
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(dotplot);
        box.add(Box.createHorizontalGlue());
        box.add(showMissingValueArea);
        box.add(Box.createHorizontalGlue());
        box.add(activeLineColor);
        box.add(Box.createHorizontalGlue());
        box.add(inactiveLineColor);
        box.add(Box.createHorizontalGlue());
        box.add(selectionAreaColor);
        box.add(Box.createHorizontalGlue());
        box.add(clearSelection);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private Samples generateSamples() {
        Samples samples = new Samples();
        Sample[] sample = new Sample[]{new Sample("SA1", samples), new Sample("SA2", samples), new Sample("SA3", samples), new Sample("SA4", samples), new Sample("SA5", samples)};
        Metrics[] metrics = new Metrics[]{new Metrics("MET0"), new Metrics("MET1"), new Metrics("MET2"), new Metrics("MET3"), new Metrics("MET4"), new Metrics("MET5"), new Metrics("MET6"), new Metrics("MET7"), new Metrics("MET8"), new Metrics("MET9")};
        Random rand = new Random();
        for (int i = 0; i < sample.length; ++i) {
            for (int j = 0; j < metrics.length; ++j) {
                if (rand.nextInt(100) >= 95) continue;
                sample[i].setValue(metrics[j], rand.nextInt(100));
            }
            samples.addSample(sample[i]);
        }
        return samples;
    }

    public static void main(String[] args) throws Exception {
        new ExampleView(args);
    }
}

