/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.pcp.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PcpGraphSetting
implements Serializable {
    private static final long serialVersionUID = 4134897821731566626L;
    static final int SOUTH_OFFSET = 50;
    public static final int MISSING_VALUE_OFFSET = 20;
    private int transparency;
    private boolean showMissingValueArea;
    private boolean showScales;
    private boolean dotplot;
    private Stroke activeLineStroke;
    private Color activeLineColor;
    private Stroke inactiveLineStroke;
    private Color selectionAreaColor;
    private Color inactiveLineColor;
    private Color borderColor;
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public PcpGraphSetting() {
        this.setTransparency(200);
        this.setShowMissingValueArea(true);
        this.setShowScales(true);
        this.setDotPlot(true);
        this.setActiveLineStroke(new BasicStroke(2.0f));
        this.setActiveLineColor(Color.RED);
        this.setInactiveLineStroke(new BasicStroke(1.0f));
        this.setInactiveLineColor(Color.GRAY);
        this.setBorderColor(Color.BLACK);
        this.setSelectedAreaColor(Color.DARK_GRAY);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public Color getActiveLineColor() {
        return this.activeLineColor;
    }

    public Stroke getActiveLineStroke() {
        return this.activeLineStroke;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getInactiveLineColor() {
        return this.inactiveLineColor;
    }

    public Stroke getInactiveLineStroke() {
        return this.inactiveLineStroke;
    }

    public Color getSelectedAreaColor() {
        return this.selectionAreaColor;
    }

    public int getSouthOffset() {
        int southOffset = 20;
        if (this.isShowMissingValueArea()) {
            southOffset = 50;
        }
        return southOffset;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public boolean isDotPlot() {
        return this.dotplot;
    }

    public boolean isShowMissingValueArea() {
        return this.showMissingValueArea;
    }

    public boolean isShowScales() {
        return this.showScales;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setActiveLineColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        Color c = this.activeLineColor;
        this.activeLineColor = color;
        this.fireEvent(new PropertyChangeEvent(this, "active_line_color", c, color));
    }

    public void setActiveLineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new NullPointerException();
        }
        Stroke s = this.activeLineStroke;
        this.activeLineStroke = stroke;
        this.fireEvent(new PropertyChangeEvent(this, "active_line_stroke", s, stroke));
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        Color c = this.borderColor;
        this.borderColor = color;
        this.fireEvent(new PropertyChangeEvent(this, "border_color", c, this.borderColor));
    }

    public void setDotPlot(boolean dotplot) {
        Boolean b = new Boolean(this.dotplot);
        this.dotplot = dotplot;
        this.fireEvent(new PropertyChangeEvent(this, "dot_plot", b, dotplot));
    }

    public void setInactiveLineColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        Color c = this.inactiveLineColor;
        this.inactiveLineColor = color;
        this.fireEvent(new PropertyChangeEvent(this, "inactive_line_color", c, color));
    }

    public void setInactiveLineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new NullPointerException();
        }
        Stroke s = this.inactiveLineStroke;
        this.inactiveLineStroke = stroke;
        this.fireEvent(new PropertyChangeEvent(this, "inactive_line_stroke", s, stroke));
    }

    public void setSelectedAreaColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        Color c = this.selectionAreaColor;
        this.selectionAreaColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.getTransparency());
        this.fireEvent(new PropertyChangeEvent(this, "selected_area_color", c, color));
    }

    public void setShowMissingValueArea(boolean showMissingValueArea) {
        Boolean b = new Boolean(this.showMissingValueArea);
        this.showMissingValueArea = showMissingValueArea;
        this.fireEvent(new PropertyChangeEvent(this, "show_missing_value_area", b, showMissingValueArea));
    }

    public void setShowScales(boolean showScales) {
        Boolean b = new Boolean(this.showScales);
        this.showScales = showScales;
        this.fireEvent(new PropertyChangeEvent(this, "show_scales", b, showScales));
    }

    public void setTransparency(int transparency) {
        if (transparency < 0 || transparency > 255) {
            throw new IllegalArgumentException("transparency must be 0-255: " + transparency);
        }
        Integer i = new Integer(this.transparency);
        this.transparency = transparency;
        Color c = this.selectionAreaColor;
        if (c != null) {
            this.selectionAreaColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), transparency);
        }
        this.fireEvent(new PropertyChangeEvent(this, "transparency", i, transparency));
    }

    protected void fireEvent(PropertyChangeEvent e) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(e);
        }
    }
}

