/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.pcp.ui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import javax.swing.JPanel;
import jp.sourceforge.talisman.i18n.Messages;
import jp.sourceforge.talisman.pcp.MetricsDomain;
import jp.sourceforge.talisman.pcp.ui.PcpGraphSetting;

class PcpAxisPane
extends JPanel {
    private static final long serialVersionUID = -1856656107000066165L;
    private MetricsDomain[] domains;
    private PcpGraphSetting setting;
    private Messages messages;

    public PcpAxisPane(MetricsDomain[] domains, PcpGraphSetting setting, Messages messages) {
        this.domains = domains;
        this.setting = setting;
        this.messages = messages;
        this.setOpaque(false);
    }

    public synchronized void paintComponent(Graphics graphics) {
        Dimension dim = this.getSize();
        Graphics2D g = (Graphics2D)graphics;
        Color initColor = g.getColor();
        g.setColor(this.setting.getBorderColor());
        int fontHeight = g.getFontMetrics().getHeight();
        double width = dim.getWidth() / (double)this.domains.length;
        double middleWidth = width / 2.0;
        if (this.setting.isShowMissingValueArea()) {
            double missingValueLine = dim.getHeight() - 20.0;
            g.draw(new Line2D.Double(middleWidth, missingValueLine, width * (double)(this.domains.length - 1) + middleWidth, missingValueLine));
            if (this.setting.isShowScales()) {
                g.drawString(this.messages.get("missingvalue.label"), 0.0f, (float)missingValueLine + (float)fontHeight);
            }
        }
        double southOffset = this.setting.getSouthOffset();
        for (int i = 0; i < this.domains.length; ++i) {
            double offsetX = width * (double)i;
            double height = dim.getHeight() - southOffset;
            g.draw(new Line2D.Double(offsetX + middleWidth, 10.0, offsetX + middleWidth, height + 10.0));
            g.draw(new Line2D.Double(offsetX + middleWidth - 5.0, 10.0, offsetX + middleWidth + 5.0, 10.0));
            g.draw(new Line2D.Double(offsetX + middleWidth - 5.0, height + 10.0, offsetX + middleWidth + 5.0, height + 10.0));
            int max = this.domains[i].getMaximum();
            int min = this.domains[i].getMinimum();
            g.drawString(Integer.toString(max), (float)(offsetX + middleWidth + 5.0), 10.0f);
            g.drawString(Integer.toString(min), (float)(offsetX + middleWidth + 5.0), (float)height + 10.0f);
            int ssteps = this.domains[i].getScaleSteps();
            double step = (double)(max - min) / (double)ssteps;
            double sy = height / (double)ssteps;
            for (int j = 1; j < ssteps; ++j) {
                double vv = step * (double)j;
                if (!(vv > 1.0)) continue;
                g.draw(new Line2D.Double(offsetX + middleWidth - 3.0, height - sy * (double)j, offsetX + middleWidth + 3.0, height - sy * (double)j));
                if (!this.setting.isShowScales()) continue;
                g.drawString(Integer.toString((int)((double)min + vv)), (float)(offsetX + middleWidth + 5.0), (float)(height - sy * (double)j + (double)fontHeight / 2.0));
            }
        }
        g.setColor(initColor);
        super.paintComponent(g);
    }
}

