/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.pcp.ui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import jp.sourceforge.talisman.pcp.MetricsDomain;
import jp.sourceforge.talisman.pcp.Sample;
import jp.sourceforge.talisman.pcp.Samples;
import jp.sourceforge.talisman.pcp.ui.PcpGraphSetting;

class PcpMainPane
extends JPanel {
    private static final long serialVersionUID = 4743119584650784221L;
    private Samples samples;
    private MetricsDomain[] domains;
    private PcpGraphSetting setting;

    public PcpMainPane(Samples samples, MetricsDomain[] domains, PcpGraphSetting setting) {
        this.samples = samples;
        this.domains = domains;
        this.setting = setting;
        this.setOpaque(false);
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Color initColor = g.getColor();
        Stroke initStroke = g.getStroke();
        Dimension dim = this.getSize();
        double width = dim.getWidth() / (double)this.domains.length;
        double height = dim.getHeight() - (double)this.setting.getSouthOffset();
        double middleWidth = width / 2.0;
        for (Sample sample : this.samples) {
            Point2D.Double lastPoint = null;
            if (sample.isActive()) {
                g.setColor(this.setting.getActiveLineColor());
                g.setStroke(this.setting.getActiveLineStroke());
            } else {
                g.setColor(this.setting.getInactiveLineColor());
                g.setStroke(this.setting.getInactiveLineStroke());
            }
            for (int i = 0; i < this.domains.length; ++i) {
                Point2D.Double currentPoint;
                double step = height / (double)(this.domains[i].getMaximum() - this.domains[i].getMinimum());
                double offsetX = width * (double)i;
                boolean valueExists = sample.hasValue(this.domains[i].getMetrics());
                if (valueExists) {
                    int v = sample.getValue(this.domains[i].getMetrics()) - this.domains[i].getMinimum();
                    currentPoint = new Point2D.Double(offsetX + middleWidth, 10.0 + height - (double)v * step);
                    if (this.setting.isDotPlot()) {
                        g.fill(new Ellipse2D.Double(offsetX + middleWidth - 3.0, 10.0 + height - (double)v * step - 3.0, 6.0, 6.0));
                    }
                } else {
                    double missingValueLine = dim.getHeight() - 20.0;
                    currentPoint = new Point2D.Double(offsetX + middleWidth, missingValueLine);
                }
                if (lastPoint != null) {
                    if (!valueExists && !this.setting.isShowMissingValueArea()) {
                        currentPoint = null;
                    }
                    if (currentPoint != null && lastPoint != null) {
                        g.draw(new Line2D.Double(lastPoint, currentPoint));
                    }
                }
                lastPoint = currentPoint;
            }
        }
        g.setStroke(initStroke);
        g.setColor(initColor);
        super.paintComponent(g);
    }
}

