/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.pcp.ui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import javax.swing.JPanel;
import jp.sourceforge.talisman.pcp.MetricsDomain;
import jp.sourceforge.talisman.pcp.Sample;
import jp.sourceforge.talisman.pcp.Samples;
import jp.sourceforge.talisman.pcp.ui.PcpGraphSetting;

class PcpSelectedAreaPane
extends JPanel {
    private static final long serialVersionUID = 4628532390115960095L;
    private MetricsDomain[] inactiveDomains;
    private MetricsDomain[] domains;
    private int targetDomainNumber = -1;
    private boolean upperSide = false;
    private Samples samples;
    private PcpGraphSetting setting;

    public PcpSelectedAreaPane(Samples samples, MetricsDomain[] domains, PcpGraphSetting setting) {
        this.samples = samples;
        this.domains = domains;
        this.setting = setting;
        this.initData();
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                PcpSelectedAreaPane.this.pointDetermination(e);
            }

            public void mouseReleased(MouseEvent e) {
                if (PcpSelectedAreaPane.this.targetDomainNumber >= 0) {
                    PcpSelectedAreaPane.this.updateSelection(e);
                    PcpSelectedAreaPane.this.targetDomainNumber = -1;
                    PcpSelectedAreaPane.this.repaint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (PcpSelectedAreaPane.this.targetDomainNumber >= 0) {
                    PcpSelectedAreaPane.this.updateSelection(e);
                    PcpSelectedAreaPane.this.repaint();
                }
            }
        });
    }

    public void clearSelection() {
        this.initData();
        for (Sample sample : this.samples) {
            sample.setActive(true);
        }
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Color initColor = g.getColor();
        Dimension dim = this.getSize();
        GeneralPath upper = this.generateGeneralPath(dim, true);
        GeneralPath lower = this.generateGeneralPath(dim, false);
        g.setColor(this.setting.getSelectedAreaColor());
        g.fill(upper);
        g.fill(lower);
        g.setColor(initColor);
        super.paintComponent(g);
    }

    private GeneralPath generateGeneralPath(Dimension dim, boolean upper) {
        double width = dim.getWidth() / (double)this.domains.length;
        double middleWidth = width / 2.0;
        double height = dim.getHeight() - (double)this.setting.getSouthOffset();
        float offsetY = (float)height;
        if (upper) {
            offsetY = 0.0f;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo((float)middleWidth, 10.0f + offsetY);
        for (int i = 0; i < this.inactiveDomains.length; ++i) {
            double step = height / (double)Math.abs(this.domains[i].getMaximum() - this.domains[i].getMinimum());
            int domainValue = this.inactiveDomains[i].getMaximum();
            if (!upper) {
                domainValue = this.inactiveDomains[i].getMinimum();
            }
            int value = domainValue - this.domains[i].getMinimum();
            float lineHeight = (float)(height - step * (double)value);
            path.lineTo((float)((double)i * width + middleWidth), lineHeight + 10.0f);
        }
        path.lineTo((float)(dim.getWidth() - middleWidth), 10.0f + offsetY);
        path.closePath();
        return path;
    }

    private void initData() {
        this.inactiveDomains = new MetricsDomain[this.domains.length];
        for (int i = 0; i < this.domains.length; ++i) {
            this.inactiveDomains[i] = new MetricsDomain(this.domains[i]);
        }
    }

    private void pointDetermination(MouseEvent e) {
        Dimension dim = this.getSize();
        double width = dim.getWidth() / (double)this.domains.length;
        double middlePoint = width / 2.0;
        double height = dim.getHeight() - (double)this.setting.getSouthOffset();
        int x = e.getX();
        for (int i = 0; i < this.domains.length; ++i) {
            double stepY = height / (double)(this.domains[i].getMaximum() - this.domains[i].getMinimum());
            double offsetX = width * (double)i + middlePoint;
            if (!(Math.abs(offsetX - (double)x) < 5.0)) continue;
            int y = e.getY();
            double upperY = 10.0 + height - stepY * (double)(this.inactiveDomains[i].getMaximum() - this.domains[i].getMinimum());
            double lowerY = 10.0 + height - stepY * (double)(this.inactiveDomains[i].getMinimum() - this.domains[i].getMinimum());
            if (Math.abs(upperY - (double)y) < 5.0) {
                this.upperSide = true;
                this.targetDomainNumber = i;
                break;
            }
            if (!(Math.abs(lowerY - (double)y) < 5.0)) continue;
            this.upperSide = false;
            this.targetDomainNumber = i;
            break;
        }
    }

    private void updateSelection(MouseEvent e) {
        Dimension dim = this.getSize();
        int y = e.getY();
        MetricsDomain orig = this.domains[this.targetDomainNumber];
        MetricsDomain target = this.inactiveDomains[this.targetDomainNumber];
        double height = dim.getHeight() - (double)this.setting.getSouthOffset();
        double stepY = height / (double)(orig.getMaximum() - orig.getMinimum());
        int newValue = Math.round((float)((height - (double)y) / stepY)) + orig.getMinimum();
        if (this.upperSide) {
            if (orig.getMaximum() < newValue) {
                newValue = orig.getMaximum();
            }
            target.setMaximum(newValue);
        } else {
            if (orig.getMinimum() > newValue) {
                newValue = orig.getMinimum();
            }
            target.setMinimum(newValue);
        }
        for (Sample sample : this.samples) {
            boolean activeFlag = true;
            for (MetricsDomain md : this.inactiveDomains) {
                int value;
                if (!sample.hasValue(md.getMetrics()) || (value = sample.getValue(md.getMetrics()).intValue()) <= md.getMaximum() && value >= md.getMinimum()) continue;
                activeFlag = false;
                break;
            }
            sample.setActive(activeFlag);
        }
    }
}

