/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.i18n;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jp.sourceforge.talisman.i18n.ResourceNotFoundException;

public class Messages {
    private Locale currentLocale;
    private String resourcePath;
    private Map<Locale, ResourceBundle> resources = new HashMap<Locale, ResourceBundle>();

    public Messages(Locale defaultLocale, String resourcePath) throws ResourceNotFoundException {
        this.resourcePath = resourcePath;
        this.currentLocale = defaultLocale;
        ResourceBundle rb = this.getBundle(defaultLocale);
        if (rb == null) {
            throw new ResourceNotFoundException(String.valueOf(resourcePath) + " is not found");
        }
    }

    public Messages(String resourcePath) throws ResourceNotFoundException {
        this(Locale.getDefault(), resourcePath);
    }

    public String format(Locale locale, String key, Object ... args) {
        String value = this.get(locale, key);
        if (value != null) {
            return MessageFormat.format(value, args);
        }
        return value;
    }

    public String format(String key, Object ... args) {
        return this.format(this.getLocale(), key, args);
    }

    public String get(Locale locale, String key) {
        return this.get(locale, key, null);
    }

    /*
     * Unable to fully structure code
     */
    public String get(Locale locale, String key, String defaultValue) {
        rb = this.getBundle(locale);
        currentIndex = 0;
        try {
            value = rb.getString(key);
            ** GOTO lbl34
        }
        catch (MissingResourceException e) {
            value = defaultValue;
            if (value != null) ** GOTO lbl34
            return null;
        }
lbl-1000:
        // 1 sources

        {
            index = value.indexOf(36, currentIndex);
            if (value.charAt(index + 1) == '$') {
                currentIndex = index + 2;
                continue;
            }
            if (value.charAt(index + 1) == '{') {
                currentIndex = index;
                last = value.indexOf(125, currentIndex + 1);
                if (last > 0) {
                    subkey = value.substring(index + 2, last);
                    if (!this.hasValue(locale, subkey)) continue;
                    subvalue = this.get(locale, subkey);
                    builder = new StringBuilder();
                    builder.append(value.substring(0, currentIndex));
                    builder.append(subvalue);
                    builder.append(value.substring(last + 1));
                    currentIndex += subvalue.length() + 1;
                    value = new String(builder);
                    continue;
                }
                ++currentIndex;
                continue;
            }
            currentIndex = index + 1;
lbl34:
            // 7 sources

            ** while (value.indexOf((int)36, (int)currentIndex) >= 0)
        }
lbl35:
        // 1 sources

        return value;
    }

    public String get(String key) {
        return this.get(this.getLocale(), key);
    }

    public String get(String key, String defaultValue) {
        return this.get(this.getLocale(), key, defaultValue);
    }

    public String[] getArray(Locale locale, String key) {
        String value = this.get(locale, key);
        if (value != null) {
            return value.split(", *");
        }
        return new String[0];
    }

    public String[] getArray(String key) {
        return this.getArray(this.getLocale(), key);
    }

    public Icon getIcon(Locale locale, String key) {
        String value = this.get(locale, key);
        if (value != null && (value.endsWith(".png") || value.endsWith(".jpg") || value.endsWith(".gif"))) {
            return new ImageIcon(this.getClass().getResource(value));
        }
        return null;
    }

    public Icon getIcon(String key) {
        return this.getIcon(this.getLocale(), key);
    }

    public Locale getLocale() {
        return this.currentLocale;
    }

    public boolean hasValue(Locale locale, String key) {
        try {
            ResourceBundle rb = this.getBundle(locale);
            rb.getString(key);
            return true;
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }

    public boolean hasValue(String key) {
        return this.hasValue(this.getLocale(), key);
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.currentLocale = locale;
    }

    private ResourceBundle getBundle(Locale locale) {
        ResourceBundle rb = this.resources.get(locale);
        if (rb == null) {
            try {
                rb = ResourceBundle.getBundle(this.resourcePath, locale);
                this.resources.put(locale, rb);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return rb;
    }
}

