package jp.sourceforge.talisman.pcp;

/*
 * $Id: MetricsDomain.java 132 2008-07-15 03:30:47Z tama3 $
 */

import java.io.Serializable;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class MetricsDomain implements Serializable{
    private static final long serialVersionUID = -2815359557778693698L;
    public static final int DEFAULT_SCALE_STEPS = 5;

    private Metrics metrics;
    private int maximum = Integer.MIN_VALUE;
    private int minimum = Integer.MAX_VALUE;
    private int scaleSteps = DEFAULT_SCALE_STEPS;

    public MetricsDomain(Metrics metrics, int maximum, int minimum){
        this(metrics);
        this.maximum = maximum;
        this.minimum = minimum;
    }

    public MetricsDomain(Metrics metrics, int maximum, int minimum, int scaleSteps){
        this(metrics);
        this.maximum = maximum;
        this.minimum = minimum;
        this.scaleSteps = scaleSteps;
    }

    public MetricsDomain(Metrics metrics){
        setMetrics(metrics);
    }

    /**
     * self constructor.
     */
    public MetricsDomain(MetricsDomain domain){
        this(
            domain.getMetrics(), domain.getMaximum(),
            domain.getMinimum(), domain.getScaleSteps()
        );
    }

    public int getScaleSteps(){
        return scaleSteps;
    }

    public void setScaleSteps(int scaleSteps){
        this.scaleSteps = scaleSteps;
    }

    public Metrics getMetrics(){
        return metrics;
    }

    public void setMetrics(Metrics metrics){
        if(metrics == null){
            throw new NullPointerException();
        }
        this.metrics = metrics;
    }

    public int getMaximum(){
        return maximum;
    }

    public void setMaximum(int maximum){
        this.maximum = maximum;
    }

    public int getMinimum(){
        return minimum;
    }

    public void setMinimum(int minimum){
        this.minimum = minimum;
    }

}
