package jp.sourceforge.talisman.pcp.ui.swing;

/*
 * $Id: PcpAxisPane.java 132 2008-07-15 03:30:47Z tama3 $
 */

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;

import javax.swing.JPanel;

import jp.sourceforge.talisman.i18n.Messages;
import jp.sourceforge.talisman.pcp.MetricsDomain;
import jp.sourceforge.talisman.pcp.ui.PcpGraphSetting;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
class PcpAxisPane extends JPanel{
    private static final long serialVersionUID = -1856656107000066165L;

    private MetricsDomain[] domains;
    private PcpGraphSetting setting;
    private Messages messages;

    public PcpAxisPane(MetricsDomain[] domains, PcpGraphSetting setting, Messages messages){
        this.domains = domains;
        this.setting = setting;
        this.messages = messages;
        setOpaque(false);
    }

    @Override
    public synchronized void paintComponent(Graphics graphics){
        Dimension dim = getSize();
        Graphics2D g = (Graphics2D)graphics;

        Color initColor = g.getColor();
        g.setColor(setting.getBorderColor());
        int fontHeight = g.getFontMetrics().getHeight();

        double width = dim.getWidth() / domains.length;
        double middleWidth = width / 2;
        if(setting.isShowMissingValueArea()){
            double missingValueLine = dim.getHeight() - PcpGraphSetting.MISSING_VALUE_OFFSET;
            g.draw(new Line2D.Double(middleWidth, missingValueLine, width * (domains.length - 1) + middleWidth, missingValueLine));
            if(setting.isShowScales()){
                g.drawString(messages.get("missingvalue.label"), 0f, (float)missingValueLine + fontHeight);
            }
        }
        double southOffset = setting.getSouthOffset();

        for(int i = 0; i < domains.length; i++){
            double offsetX = width * i;
            double height = dim.getHeight() - southOffset;
            g.draw(new Line2D.Double(offsetX + middleWidth, 10d, offsetX + middleWidth, height + 10d));
            g.draw(new Line2D.Double(offsetX + middleWidth - 5, 10d, offsetX + middleWidth + 5, 10d));
            g.draw(new Line2D.Double(offsetX + middleWidth - 5, height + 10d, offsetX + middleWidth + 5, height + 10d));

            int max = domains[i].getMaximum();
            int min = domains[i].getMinimum();

            g.drawString(Integer.toString(max), (float)(offsetX + middleWidth + 5), 10f);
            g.drawString(Integer.toString(min), (float)(offsetX + middleWidth + 5), (float)height + 10f);

            int ssteps = domains[i].getScaleSteps();
            double step = (max - min) / (double)ssteps;
            double sy = height / ssteps;
            for(int j = 1; j < ssteps; j++){
                double vv = step * j;
                if(vv > 1){
                    g.draw(new Line2D.Double(offsetX + middleWidth - 3, height - (sy * j), offsetX + middleWidth + 3, height - (sy * j)));
                    if(setting.isShowScales()){
                        g.drawString(
                            Integer.toString((int)(min + vv)),
                            (float)(offsetX + middleWidth + 5), (float)((height - (sy * j) + (fontHeight / 2d)))
                        );
                    }
                }
            }
        }

        g.setColor(initColor);
        super.paintComponent(g);
    }
}
