package jp.sourceforge.talisman.pcp.ui.swing.actions;

/*
 * $Id: MissingValueAreaShowAction.java 132 2008-07-15 03:30:47Z tama3 $
 */

import java.awt.event.ActionEvent;

import jp.sourceforge.talisman.pcp.ui.swing.PcpPane;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class MissingValueAreaShowAction extends JToggleButtonAction{
    private static final long serialVersionUID = -3711431733333916899L;

    private PcpPane pcp;

    public MissingValueAreaShowAction(PcpPane pcp){
        this.pcp = pcp;
        putValue(ACTION_COMMAND_KEY, "showmissingvaluearea");
        putValue(NAME, pcp.getMessages().get("showmissingvaluearea.label"));
        if(pcp.getMessages().hasValue("showmissingvaluearea.icon")){
            putValue(SMALL_ICON, pcp.getMessages().getIcon("showmissingvaluearea.icon"));
        }
    }

    public void actionPerformed(ActionEvent e){
        boolean showMissingValueArea = isChecked(e);
        pcp.getSetting().setShowMissingValueArea(showMissingValueArea);
    }
}
