package jp.sourceforge.talisman.pcp;

/*
 * $Id: SampleTest.java 132 2008-07-15 03:30:47Z tama3 $
 */

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.junit.Before;
import org.junit.Test;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class SampleTest{
    private Samples samples;
    private Sample sample;

    @Before
    public void initialize(){
        samples = new Samples();
        sample = new Sample("sample1", samples);

        sample.setValue(new Metrics("metrics1"), 1);
        sample.setValue(new Metrics("metrics2"), 2);
        sample.setValue(new Metrics("metrics3"), 3);
        sample.setValue(new Metrics("metrics4"), 4);
        sample.setValue(new Metrics("metrics5"), 5);
    }

    @Test
    public void testActive(){
        assertTrue(sample.isActive());
        sample.setActive(false);
        assertFalse(sample.isActive());
    }

    @Test
    public void testEquals(){
        Sample sample2 = new Sample("sample1");

        sample2.setValue(new Metrics("metrics1"), 1);
        sample2.setValue(new Metrics("metrics2"), 2);
        sample2.setValue(new Metrics("metrics3"), 3);
        sample2.setValue(new Metrics("metrics4"), 4);
        sample2.setValue(new Metrics("metrics5"), 5);

        assertTrue(sample.equals(sample2));
        assertTrue(sample2.equals(sample));
        assertTrue(sample.hashCode() == sample2.hashCode());
    }

    /**
     * addValue order is different.
     */
    @Test
    public void testEqualsFail(){
        Sample sample2 = new Sample("sample1");

        sample2.setValue(new Metrics("metrics1"), 1);
        sample2.setValue(new Metrics("metrics3"), 3);
        sample2.setValue(new Metrics("metrics2"), 2);
        sample2.setValue(new Metrics("metrics4"), 4);
        sample2.setValue(new Metrics("metrics5"), 5);

        assertFalse(sample.equals(sample2));
        assertFalse(sample2.equals(sample));
        assertFalse(sample.hashCode() == sample2.hashCode());
    }

    @Test
    public void testMetrics(){
        Metrics[] metrics = new Metrics[] {
            new Metrics("metrics1"), new Metrics("metrics2"),
            new Metrics("metrics3"), new Metrics("metrics4"),
            new Metrics("metrics5"),
        };

        int index = 0;
        for(Iterator<Metrics> i = sample.metrics(); i.hasNext(); ){
            assertTrue(metrics[index].equals(i.next()));
            index++;
        }
    }

    @Test
    public void testGetId(){
        assertEquals("sample1", sample.getId());
    }

    @Test
    public void testGetValue(){
        assertEquals(1, sample.getValue(new Metrics("metrics1")));
        assertEquals(2, sample.getValue(new Metrics("metrics2")));
        assertEquals(3, sample.getValue(new Metrics("metrics3")));
        assertEquals(4, sample.getValue(new Metrics("metrics4")));
        assertEquals(5, sample.getValue(new Metrics("metrics5")));
    }

    @Test
    public void testHasValue(){
        assertTrue(sample.hasValue(new Metrics("metrics1")));
        assertTrue(sample.hasValue(new Metrics("metrics2")));
        assertTrue(sample.hasValue(new Metrics("metrics3")));
        assertTrue(sample.hasValue(new Metrics("metrics4")));
        assertTrue(sample.hasValue(new Metrics("metrics5")));
    }

    @Test(expected=NullPointerException.class)
    public void testNullId(){
        new Sample(null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullSamples1(){
        new Sample("sample1", null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullSamples2(){
        Sample sample = new Sample("sample1");
        sample.setSamples(null);
    }

    @Test
    public void testRemove(){
        sample.removeValue(new Metrics("metrics2"));

        assertTrue(sample.hasValue(new Metrics("metrics1")));
        assertFalse(sample.hasValue(new Metrics("metrics2")));
        assertTrue(sample.hasValue(new Metrics("metrics3")));
        assertTrue(sample.hasValue(new Metrics("metrics4")));
        assertTrue(sample.hasValue(new Metrics("metrics5")));
    }

    @Test
    public void testSamples(){
        Set<Metrics> metricsSet = new HashSet<Metrics>();
        metricsSet.add(new Metrics("metrics1"));
        metricsSet.add(new Metrics("metrics2"));
        metricsSet.add(new Metrics("metrics3"));
        metricsSet.add(new Metrics("metrics4"));
        metricsSet.add(new Metrics("metrics5"));

        for(Metrics metrics: samples.getAvailableMetrics()){
            assertTrue(metricsSet.contains(metrics));
        }
    }

    @Test
    public void testSamples2(){
        Samples newSamples = new Samples();
        sample.setSamples(newSamples);

        Set<Metrics> metricsSet = new HashSet<Metrics>();
        metricsSet.add(new Metrics("metrics1"));
        metricsSet.add(new Metrics("metrics2"));
        metricsSet.add(new Metrics("metrics3"));
        metricsSet.add(new Metrics("metrics4"));
        metricsSet.add(new Metrics("metrics5"));

        for(Metrics metrics: newSamples.getAvailableMetrics()){
            assertTrue(metricsSet.contains(metrics));
            metricsSet.remove(metrics);
        }
        assertEquals(0, metricsSet.size());
    }

    @Test
    public void testSetSamples(){
        Sample sample = new Sample("sample1");

        assertNull(sample.getSamples());

        sample.setSamples(samples);
        assertEquals(samples, sample.getSamples());
    }

    @Test
    public void testToString(){
        assertEquals(
            "sample1={ [metrics1=1], [metrics2=2], [metrics3=3], [metrics4=4], [metrics5=5] }",
            sample.toString()
        );
    }
}
