package jp.sourceforge.talisman.pcp;

/*
 * $Id: SamplesTest.java 132 2008-07-15 03:30:47Z tama3 $
 */

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.HashSet;
import java.util.Set;

import org.junit.Before;
import org.junit.Test;

/**
 * 
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class SamplesTest{
    private Samples samples;
    private Sample sample1;
    private Sample sample2;
    private Sample sample3;

    @Before
    public void initialize(){
        samples = new Samples();

        sample1 = new Sample("sample1", samples);
        sample2 = new Sample("sample2", samples);
        sample3 = new Sample("sample3", samples);

        sample1.setValue(new Metrics("metrics1"), 11);
        sample1.setValue(new Metrics("metrics2"), 12);
        sample1.setValue(new Metrics("metrics3"), 13);

        sample2.setValue(new Metrics("metrics1"), 21);
        sample2.setValue(new Metrics("metrics2"), 22);
        sample2.setValue(new Metrics("metrics3"), 23);

        sample3.setValue(new Metrics("metrics1"), 31);
        sample3.setValue(new Metrics("metrics2"), 32);
        sample3.setValue(new Metrics("metrics3"), 33);

        samples.addSample(sample1);
        samples.addSample(sample2);
        samples.addSample(sample3);
    }

    @Test
    public void testBasic(){
        assertEquals(3, samples.getSampleCount());

        Sample[] sampleArray1 = samples.getSamples();
        assertTrue(sampleArray1[0] == sample1);
        assertTrue(sampleArray1[1] == sample2);
        assertTrue(sampleArray1[2] == sample3);
    }

    @Test
    public void testRemove(){
        samples.removeSample(sample2);
        assertEquals(2, samples.getSampleCount());
        assertEquals(2, samples.getSelectedSampleCount());

        Sample[] sampleArray = samples.getSamples();
        assertTrue(sampleArray[0] == sample1);
        assertTrue(sampleArray[1] == sample3);
    }

    @Test
    public void testInitialSelected(){
        assertEquals(3, samples.getSelectedSampleCount());

        Sample[] sampleArray = samples.getSelectedSamples();
        assertTrue(sampleArray[0] == sample1);
        assertTrue(sampleArray[1] == sample2);
        assertTrue(sampleArray[2] == sample3);
    }

    @Test
    public void testSetSelectedMore(){
        samples.setSelected(new Metrics("metrics1"), 11, Criterion.MORE);

        assertEquals(2, samples.getSelectedSampleCount());

        Sample[] sampleArray = samples.getSelectedSamples();
        assertTrue(sampleArray[0] == sample2);
        assertTrue(sampleArray[1] == sample3);
    }

    @Test
    public void testSetSelectedMoreEquals(){
        samples.setSelected(new Metrics("metrics1"), 11, Criterion.MORE_EQUALS);

        assertEquals(3, samples.getSelectedSampleCount());

        Sample[] sampleArray = samples.getSelectedSamples();
        assertTrue(sampleArray[0] == sample1);
        assertTrue(sampleArray[1] == sample2);
        assertTrue(sampleArray[2] == sample3);
    }

    @Test
    public void testSetSelectedLess(){
        samples.setSelected(new Metrics("metrics2"), 22, Criterion.LESS);

        assertEquals(1, samples.getSelectedSampleCount());

        Sample[] sampleArray = samples.getSelectedSamples();
        assertTrue(sampleArray[0] == sample1);
    }

    @Test
    public void testSetSelectedLessEquals(){
        samples.setSelected(new Metrics("metrics2"), 22, Criterion.LESS_EQUALS);

        assertEquals(2, samples.getSelectedSampleCount());

        Sample[] sampleArray = samples.getSelectedSamples();
        assertTrue(sampleArray[0] == sample1);
        assertTrue(sampleArray[1] == sample2);
    }

    @Test
    public void testSetSelectedEquals(){
        samples.setSelected(new Metrics("metrics2"), 22, Criterion.EQUALS);

        assertEquals(1, samples.getSelectedSampleCount());

        Sample[] sampleArray = samples.getSelectedSamples();
        assertTrue(sampleArray[0] == sample2);
    }

    @Test
    public void testMetrics(){
        Set<Metrics> set = new HashSet<Metrics>();
        set.add(new Metrics("metrics1"));
        set.add(new Metrics("metrics2"));
        set.add(new Metrics("metrics3"));

        for(Metrics metrics: samples.getAvailableMetrics()){
            assertTrue(set.contains(metrics));
            set.remove(metrics);
        }

        assertEquals(0, set.size());
    }
}
