package jp.sourceforge.talisman.fmv;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoryStateTest{
    private MemoryState state;

    @Before
    public void initialize(){
    }

    @Test
    public void testBasic(){
        state = new MemoryState();

        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        long max = runtime.maxMemory();

        Assert.assertEquals(free, state.getFreeMemory());
        Assert.assertEquals(total, state.getTotalMemory());
        Assert.assertEquals(max, state.getMaxMemory());

        Assert.assertEquals(total - free, state.getUsedMemory());
        Assert.assertEquals((double)(total - free) / total, state.getUsedMemoryRatio(), 1E-6);

        Assert.assertEquals(max != Long.MAX_VALUE, state.isMaxLimitted());

        Assert.assertEquals(
            String.format("free: %d/%d, max: %s (%s)", free, total, max, max != Long.MAX_VALUE),
            state.toString()
        );
    }

    @Test
    public void testBasic2(){
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        long max = runtime.maxMemory();

        state = new MemoryState(free, total, max);

        Assert.assertEquals(free, state.getFreeMemory());
        Assert.assertEquals(total, state.getTotalMemory());
        Assert.assertEquals(max, state.getMaxMemory());

        Assert.assertEquals(total - free, state.getUsedMemory());
        Assert.assertEquals((double)(total - free) / total, state.getUsedMemoryRatio(), 1E-6);

        Assert.assertEquals(max != Long.MAX_VALUE, state.isMaxLimitted());

        Assert.assertEquals(
            String.format("free: %d/%d, max: %s (%s)", free, total, max, max != Long.MAX_VALUE),
            state.toString()
        );
    }
}
