module TapKit

	class FetchSpec
		attr_accessor :entity_name, :limit, :hints, :relationship_keypaths, :qualifier, \
			:raw_row_keypaths, :sort_orderings
		attr_writer :deep, :lock, :prompt, :refresh, :miss_binding, :distinct

		def initialize( entity_name, qualifier = nil, sort_orderings = [], \
			distinct = false, deep = true, hints = {} )
			@entity_name           = entity_name
			@qualifier             = qualifier
			@sort_orderings        = sort_orderings
			@distinct              = distinct
			@deep                  = deep
			@hints                 = hints
			@relationship_keypaths = []
			@limit                 = 0
			@lock                  = false
			@prompt                = false
			@refresh               = false
			@miss_binding          = false
		end

		def deep?
			@deep
		end

		def lock?
			@lock
		end

		def refresh?
			@refresh
		end

		def miss_binding?
			@miss_binding
		end

		def distinct?
			@distinct
		end

		def fetch_raw_rows?
			unless @raw_row_keypaths.nil? then
				true
			else
				false
			end
		end

		def fetch_raw_rows=( flag )
			if flag == true then
				@raw_row_keypaths = []
			else
				@raw_row_keypaths = nil
			end
		end
	end


	class AggregateSpec
		AVG       = :avg
		MAX       = :max
		MIN       = :min
		SUM       = :sum
		COUNT     = :count
		COUNT_ALL = :count_all

		attr_accessor :entity_name, :attributes, \
			:group_by, :qualifier, :having, :sort_orderings

		def initialize( entity_name, qualifier = nil, sort_orderings = [] )
			@entity_name    = entity_name
			@qualifier      = qualifier
			@sort_orderings = sort_orderings
			@attributes     = [] # [{key, name, function}, ...]
		end

		# ex) aggspec.add("sum_name", "name", AggregateSpec::SUM)
		def add( key, name, function )
			@attributes << {:key => key, :name => name, :function => function}
		end

		def group( name, qulafier = nil )
			@group_by = name
			@having = qualifier
		end
	end

end
