module TapKit
	module RelationshipManipulation
		# Not yet implemented.
		def add_object_to_both_sides_of_relationship( object, key )
		end

		def add_object_to_property( object, key )
			to_one, to_many = _keys_with_validation key

			if to_one.include? key then
				take_value(key, object)
			else
				# search add_to_key method
				setter = "add_to_#{key}"
				if respond_to? setter then
					__send__(setter, object)
				else
					values = retrieve_value key
					unless values.include? object then
						values << object
					end
					take_value(key, object)
				end
			end
		end

		def remove_object_from_both_sides_of_relationship( object, key )
			to_one, to_many = _keys_with_validation key

			# update this side
			if to_many.include? key then
				remove_object_from_property(object, key)
			else
				# set nil to to-one relationship
				add_object_to_property(nil, key)
			end

			# update the another side
			unless backrel = inverse(key) then
				return
			end

			dest_cd = class_description.class_description key
			if dest_cd.to_many_relationship_keys.include? backrel then
				object.remove_object_from_property(self, backrel)
			else
				object.add_object_to_property(nil, backrel)
			end
		end

		def remove_object_from_property( object, key )
			to_one, to_many = _keys_with_validation key

			if to_one.include? key then
				unless retrieve_value(key) == object then
					raise "Object #{object} is not set for key '#{key}'"
				end
				take_value(key, nil)
			else
				# search remove_from_key method
				setter = "remove_from_#{key}"
				if respond_to? setter then
					__send__(setter, object)
				else
					values = retrieve_value key
					values.delete object
					take_value(key, values)
				end
			end
		end

		private

		def _keys_with_validation( key )
			to_one  = class_description.to_one_relationship_keys
			to_many = class_description.to_many_relationship_keys

			unless (to_one + to_many).include?(key) then
				raise "Key '#{key}' is not a relationship"
			end

			[to_one, to_many]
		end
	end
end

