class TestTimestamp < Test::Unit::TestCase
	include TapKit

	def setup
		@timestamp = Timestamp.new(2003,12,15,12,30,30)
	end

	def test_parse
		str = '2003-12-15 12:30:30 +0900'
		timestamp = Timestamp.parse str
		assert_equal(2003, timestamp.year)
		assert_equal(12, timestamp.month)
		assert_equal(15, timestamp.day)
		assert_equal(12, timestamp.hour)
		assert_equal(30, timestamp.minute)
		assert_equal(30, timestamp.second)
		assert_equal('+0900', timestamp.zone)
	end

	def test_new
		timestamp = Timestamp.new(2003,12,15,12,30,30)
		assert_equal(2003, timestamp.year)
		assert_equal(12, timestamp.month)
		assert_equal(15, timestamp.day)
		assert_equal(12, timestamp.hour)
		assert_equal(30, timestamp.minute)
		assert_equal(30, timestamp.second)
	end

	def test_new_with_datetime
		datetime = ::DateTime.new(2003,12,15,12,30,30)
		timestamp = Timestamp.new_with_datetime datetime

		assert_equal(2003, timestamp.year)
		assert_equal(12, timestamp.month)
		assert_equal(15, timestamp.day)
		assert_equal(12, timestamp.hour)
		assert_equal(30, timestamp.minute)
		assert_equal(30, timestamp.second)
	end

	def test_new_with_datetime2
		datetime = ::Time.local(2003,12,15,12,30,30)
		timestamp = Timestamp.new_with_datetime datetime

		assert_equal(2003, timestamp.year)
		assert_equal(12, timestamp.month)
		assert_equal(15, timestamp.day)
		assert_equal(12, timestamp.hour)
		assert_equal(30, timestamp.minute)
		assert_equal(30, timestamp.second)
	end

	def test_now
		time = ::Time.new
		timestamp = Timestamp.now

		assert_equal(time.year, timestamp.year)
		assert_equal(time.month, timestamp.month)
		assert_equal(time.day, timestamp.day)
		assert_equal(time.hour, timestamp.hour)
		assert_equal(time.min, timestamp.minute)
		assert_equal(time.sec, timestamp.second)
	end

	# +, -
	def test_calc
		timestamp1 = Timestamp.new(2003,12,15,12,31,0)
		plus = @timestamp + 30
		timestamp2 = Timestamp.new(2003,12,15,12,30,0)
		minus1 = @timestamp - 30
		minus2 = @timestamp - ::Time.local(2003,12,15,12,30,30)
		minus3 = @timestamp - Timestamp.new(2003,12,15,12,30,30)
		_minus3 = DateTime.ordinal(2003,12,15,12,30,30) - DateTime.ordinal(2003,12,15,12,30,30)

		assert_equal(timestamp1, plus)
		assert_equal(timestamp2, minus1)
		assert_equal(0, minus2)
		assert_equal(_minus3, minus3)
	end

	# <=>
	def test_compare
		compare1 = @timestamp <=> Timestamp.new(2003,12,15,12,30,30)
		compare2 = @timestamp <=> Timestamp.new(2003,12,15,12,29,30)
		compare3 = @timestamp <=> Timestamp.new(2003,12,15,12,31,30)
		compare4 = @timestamp <=> ::Time.local(2003,12,15,12,30,30)
		compare5 = @timestamp <=> ::Time.local(2003,12,15,12,30,30).to_i

		assert_equal(0, compare1)
		assert_equal(1, compare2)
		assert_equal(-1, compare3)
		assert_equal(0, compare4)
		assert_equal(nil, compare5)
	end

	def test_to_date
		date = ::Date.new(2003,12,15)
		assert_equal(date, @timestamp.to_date)
	end

	def test_to_time
		time = ::Time.local(2003, 12, 15, 12, 30, 30)
		assert_equal(time, @timestamp.to_time)
	end

	def test_to_datetime
		datetime = DateTime.new(2003,12,15,12,30,30)
		assert_equal(datetime, @timestamp.to_datetime)
	end

	def test_to_s
		str = '2003-12-15 12:30:30'
		assert_equal(str, @timestamp.to_s)
	end
end


