module TapKit

	module Utilities
		class << self
			# jis, sjis, euc
			def encode( string, encoding )
				unless String === string then return string end
				require 'kconv'
				case encoding
				when 'jis'
					encoding = Kconv::JIS
				when 'sjis'
					encoding = Kconv::SJIS
				when 'euc'
					encoding = Kconv::EUC
				else
					return string
				end
				string.kconv encoding
			end
		end

		# Creates and inserts a new database object for the specified entity,
		# and returns the new object.
		def create( entity_name )
			entity      = @application.entity entity_name
			description = EntityClassDescription.new entity
			object      = description.create(self, nil)
			insert object
			object
		end

		def raw_rows( model_name, sql )
			model   = @application.model model_name
			name    = model.adapter_name
			adapter = Adapter.new_with_name(name, model)
			context = AdapterContext.new_with_name(name, adapter)
			channel = AdapterChannel.new_with_name(name, context)
			factory = adapter.expression_factory
			expr    = factory.expression sql

			channel.open
			channel.evaluate expr
			channel.fetch_all
		end
	end

end

