unit Base_Chooser;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet,
  IBTable, StrUtils, IBQuery, Provider, DBClient, DBLocal, DBLocalI,
  MainDatastore, IB, IBErrorCodes, IBSQL, IBDatabase;

type
  TChooserTemplate = class(TForm)

    bvlBorder: TBevel;

    btnOK: TButton;
    btnCancel: TButton;

    procedure Form_Create(Sender: TObject);
    procedure Form_Destroy(Sender: TObject);
    procedure Form_Show(Sender: TObject);
    procedure btnOK_Click(Sender: TObject);
  private
    { Private 錾 }
    FTransaction : TIBTransaction;
    FPreparing : Boolean;
    FErrorMessages : TStrings;
  protected
    { Protected 錾 }
    property Transaction : TIBTransaction read FTransaction;
    property Preparing : Boolean read FPreparing;
    property ErrorMessages : TStrings read FErrorMessages;

    procedure BeforePopup(); virtual; abstract;
    procedure AfterPopup(); virtual; abstract;

  public
    { Public 錾 }
    constructor Prepare();

    function Select( _transaction : TIBTransaction; var found : Boolean) : Boolean;
  end;

var
  ChooserTemplate: TChooserTemplate;

implementation

{$R *.dfm}

uses Misc_Utilities;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TChooserTemplate.Prepare();
begin
	inherited Create( Screen.ActiveForm);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TChooserTemplate.Select( _transaction : TIBTransaction; var found : Boolean) : Boolean;
begin
	FTransaction := _transaction;
	FPreparing := true;

	if ErrorMessages.Count > 0 then
	begin
		ShowMessage( FErrorMessages.Text);
		result := false;
		exit;
	end;

	found := ( ShowModal() = mrOk);
	result := found;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TChooserTemplate.Form_Create(Sender: TObject);
begin
	FErrorMessages := TStringList.Create;
end;

procedure TChooserTemplate.Form_Destroy(Sender: TObject);
begin
	FErrorMessages.Free;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TChooserTemplate.Form_Show(Sender: TObject);
begin
	ClientWidth := btnCancel.Left + btnCancel.Width + 8;
	ClientHeight := btnCancel.Top + btnCancel.Height + 8;

	BeforePopup;

	FPreparing := false;
end;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TChooserTemplate.btnOK_Click(Sender: TObject);
begin
	AfterPopup;

	if FErrorMessages.Count = 0 then
	begin
		ModalResult := mrOk;
		exit;
	end;

	ShowMessage( FErrorMessages.Text);
	FErrorMessages.Clear;
end;

end.
