unit Base_Dialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet,
  IBTable, StrUtils, IBQuery, Provider, DBClient, DBLocal, DBLocalI,
  MainDatastore, IB, IBErrorCodes, IBSQL, IBDatabase, Misc_Constants;

type
  TDialogTemplate = class(TForm)

    bvlBorder: TBevel;

    btnOK: TButton;
    btnCancel: TButton;

    procedure Form_Create(Sender: TObject);
    procedure Form_Destroy(Sender: TObject);

    procedure Form_Show(Sender: TObject);

    procedure btnOK_Click(Sender: TObject);
  private
    { Private 錾 }
    FTransaction : TIBTransaction;
    FRecordSet : TDataSet;
    FPreparing : Boolean;
    FSelecting : Boolean;
    FAppending : Boolean;
    FErrorMessages : TStrings;

    function GetBrowsing() : Boolean;

    function VerifyError() : Boolean;
  protected
    { Protected 錾 }
    property Transaction : TIBTransaction read FTransaction;
    property RecordSet : TDataSet read FRecordSet;
    property Preparing : Boolean read FPreparing;
    property Appending : Boolean read FAppending;
    property Selecting : Boolean read FSelecting;
    property Browsing : Boolean read GetBrowsing;
    property ErrorMessages : TStrings read FErrorMessages;

    procedure BeforeInput(); virtual;
    procedure AfterInput(); virtual;
    procedure BeforeSelect(); virtual;
    procedure AfterSelect(); virtual;
    procedure BeforeAppend(); virtual;
    procedure AfterAppend(); virtual;
    procedure BeforePopup(); virtual;
    procedure AfterPopup(); virtual;

  public
    { Public 錾 }
    constructor Prepare; overload;

    procedure Browse( _tran : TIBTransaction; _set : TDataSet); overload; virtual;
    procedure Select( _tran : TIBTransaction; _set : TDataSet); overload; virtual;
    procedure Append( _tran : TIBTransaction; _set : TDataSet); overload; virtual;
    procedure Delete( _tran : TIBTransaction; _set : TDataSet); overload; virtual;
  end;

var
  DialogTemplate: TDialogTemplate;

implementation

{$R *.dfm}

uses Misc_Utilities;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TDialogTemplate.Prepare;
begin
	inherited Create( Screen.ActiveForm);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TDialogTemplate.Browse( _tran : TIBTransaction; _set : TDataSet);
begin
	try
		if _set.IsEmpty then exit;

		FTransaction := _tran;
		FRecordSet := _set;
		FPreparing := true;
		FSelecting := false;
		FAppending := false;

		BeforeInput();
		if not VerifyError then exit;

		BeforeSelect();
		if not VerifyError then exit;

		btnOK.Visible := false;
		btnCancel.Default := true;

		ShowModal();
	finally
		Release;
	end;
end;

procedure TDialogTemplate.Select( _tran : TIBTransaction; _set : TDataSet);
begin
	try
		if _set.IsEmpty then exit;

		FTransaction := _tran;
		FRecordSet := _set;
		FPreparing := true;
		FSelecting := true;
		FAppending := false;

		BeforeInput();
		if not VerifyError then exit;

		BeforeSelect();
		if not VerifyError then exit;

		if ShowModal() <> mrOk then exit;

		AfterSelect;
		if not VerifyError then exit;

		AfterInput;
		if not VerifyError then exit;
	finally
		Release;
	end;
end;

procedure TDialogTemplate.Append( _tran : TIBTransaction; _set : TDataSet);
begin
	try
		if not _set.Active then exit;

		FTransaction := _tran;
		FRecordSet := _set;
		FPreparing := true;
		FSelecting := false;
		FAppending := true;

		BeforeInput();
		if not VerifyError then exit;

		BeforeAppend();
		if not VerifyError then exit;

		if ShowModal() <> mrOk then exit;

		AfterAppend;
		if not VerifyError then exit;

		AfterInput;
		if not VerifyError then exit;
	finally
		Release;
	end;
end;

procedure TDialogTemplate.Delete( _tran : TIBTransaction; _set : TDataSet);
begin
	try
		if _set.IsEmpty then exit;

		if _set.FieldByName( 'keyInstance').AsInteger <= 0 then
		begin
			_set.Delete;
		end
		else
		begin
			_set.Edit;
			_set.FieldByName( 'typStatus').AsInteger := DATA_DISABLED;
			_set.Post;
		end;
	finally
		Release;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TDialogTemplate.GetBrowsing() : Boolean;
begin
	result :=  not ( Appending or Selecting);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TDialogTemplate.VerifyError() : Boolean;
begin
	if FErrorMessages.Count > 0 then
	begin
		ShowMessage( FErrorMessages.Text);
		FErrorMessages.Clear;
		result := false;
	end
	else
		result := true;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TDialogTemplate.BeforeInput();
begin
end;

procedure TDialogTemplate.AfterInput();
begin
end;

procedure TDialogTemplate.BeforeSelect();
begin
end;

procedure TDialogTemplate.AfterSelect();
begin
end;

procedure TDialogTemplate.BeforeAppend();
begin
end;

procedure TDialogTemplate.AfterAppend();
begin
end;

procedure TDialogTemplate.BeforePopup();
begin
end;

procedure TDialogTemplate.AfterPopup();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TDialogTemplate.Form_Create(Sender: TObject);
begin
	FErrorMessages := TStringList.Create;
end;

procedure TDialogTemplate.Form_Destroy(Sender: TObject);
begin
	FErrorMessages.Free;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TDialogTemplate.Form_Show(Sender: TObject);
begin
	ClientWidth := btnCancel.Left + btnCancel.Width + 8;
	ClientHeight := btnCancel.Top + btnCancel.Height + 8;

	BeforePopup;

	FPreparing := false;

	if Browsing then Caption := Caption + ' - ֎~';
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TDialogTemplate.btnOK_Click(Sender: TObject);
begin
	AfterPopup;

	if FErrorMessages.Count = 0 then
	begin
		ModalResult := mrOk;
		exit;
	end;

	ShowMessage( FErrorMessages.Text);
	FErrorMessages.Clear;
end;

end.
