unit Base_Toolbox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet,
  IBTable, StrUtils, IBQuery, Provider, DBClient, DBLocal, DBLocalI,
  MainDatastore, IB, IBErrorCodes, IBSQL, IBDatabase;

type
  TToolboxTemplate = class(TForm)

    bvlBorder: TBevel;

    btnOK: TButton;
    btnCancel: TButton;

    procedure Form_Create(Sender: TObject);
    procedure Form_Destroy(Sender: TObject);
    procedure Form_Show(Sender: TObject);
    procedure Form_CloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btnOK_Click(Sender: TObject);
  private
    { Private 錾 }
    FErrorMessages : TStrings;

    function VerifyError() : Boolean;
  protected
    { Protected 錾 }

    procedure BeforePopup(); virtual; abstract;
    procedure AfterPopup(); virtual; abstract;

    property ErrorMessages : TStrings read FErrorMessages;

  public
    procedure Popup();
    { Public 錾 }
  end;

var
  ToolboxTemplate: TToolboxTemplate;

implementation

{$R *.dfm}

uses Misc_Utilities;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TToolboxTemplate.VerifyError() : Boolean;
begin
	if FErrorMessages.Count > 0 then
	begin
		ShowMessage( FErrorMessages.Text);
		FErrorMessages.Clear;
		result := false;
	end
	else
		result := true;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TToolboxTemplate.Popup();
begin
	try
		BeforePopup; if not VerifyError then exit;

		if ShowModal() <> mrOk then DataStore.Rollback else DataStore.Commit;

	except
		on err : EIBInterBaseError do
		begin
			DataStore.Rollback;
			case err.IBErrorCode of
			isc_lock_conflict : ShowMessage( '֘Af[^̃Rs[^ŎgpłB');
			else		    ShowMessage( err.Message);
			end;
		end;
		on err : Exception do
		begin
			DataStore.Rollback;
			ShowMessage( err.Message);
		end;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TToolboxTemplate.Form_Create(Sender: TObject);
begin
	FErrorMessages := TStringList.Create;
end;

procedure TToolboxTemplate.Form_Destroy(Sender: TObject);
begin
	FErrorMessages.Free;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TToolboxTemplate.Form_Show(Sender: TObject);
begin
	ClientWidth := btnCancel.Left + btnCancel.Width + 14;
	ClientHeight := btnCancel.Top + btnCancel.Height + 8;
end;

procedure TToolboxTemplate.Form_CloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	CanClose := VerifyError;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TToolboxTemplate.btnOK_Click(Sender: TObject);
begin
	AfterPopup;
end;

end.
