unit Chooser_Date;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet, IBQuery,
  IBDatabase, ComCtrls, DateUtils, Base_Chooser, Misc_Constants, Misc_Utilities;

function ChooseDate( var datAt : TDate) : Boolean;
function ChooseMonth( var datMonthFirstday, datMonthLastday : TDate) : Boolean;
function ChooseMonthBefore( datMax : TDate; var datMonthFirstday, datMonthLastday : TDate) : Boolean;

type
  TDateChooser = class(TChooserTemplate)
    calCalendar: TMonthCalendar;
  private
    { Private 錾 }
    procedure Retrieve( var datAt : TDate); overload;
    procedure Retrieve( var datMonthFirstday, datMonthLastday : TDate); overload;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
  end;

var
  DateChooser: TDateChooser;

implementation

{$R *.dfm}

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function ChooseDate( var datAt : TDate) : Boolean;
begin
	with TDateChooser.Prepare do
	begin
		calCalendar.Date := DateOf( datAt);

		if Select( nil, result) then Retrieve( datAt);
		Release;
	end;
end;

function ChooseMonth( var datMonthFirstday, datMonthLastday : TDate) : Boolean;
begin
	with TDateChooser.Prepare do
	begin
		calCalendar.Date := DateOf( datMonthFirstday);

		if Select( nil, result) then Retrieve( datMonthFirstday, datMonthLastday);
		Release;
	end;
end;

function ChooseMonthBefore( datMax : TDate; var datMonthFirstday, datMonthLastday : TDate) : Boolean;
begin
	with TDateChooser.Prepare do
	begin
		calCalendar.Date := DateOf( datMonthFirstday);
		calCalendar.MaxDate := datMax;

		if Select( nil, result) then Retrieve( datMonthFirstday, datMonthLastday);
		Release;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TDateChooser.Retrieve( var datAt : TDate);
begin
	datAt := DateOf( calCalendar.Date);
end;

procedure TDateChooser.Retrieve( var datMonthFirstday, datMonthLastday : TDate);
begin
	datMonthFirstday := StartOfTheMonth( calCalendar.Date);
	datMonthLastday := EndOfTheMonth( calCalendar.Date);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TDateChooser.BeforePopup();
begin
end;

procedure TDateChooser.AfterPopup();
begin
end;

end.
