unit Chooser_FaxNumber;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet, IBQuery,
  IBDatabase, ComCtrls, Grids, DBGrids, IBUpdateSQL, DateUtils,
  Base_Chooser, Misc_Constants, Misc_Utilities;

function ChooseFaxNumber( _tran : TIBTransaction; var strFaxNumber : String) : Boolean; overload;

type
  TFaxNumberChooser = class(TChooserTemplate)

    AddressOnTheDay: TIBQuery;

    DataSourceOf_Address: TDataSource;

    Zip: TIBQuery;

    pagesHolder: TPageControl;

    pageCondition: TTabSheet;
    lblCategory: TLabel;
    cboCategory: TComboBox;
    txtNameRead: TLabeledEdit;
    txtName: TLabeledEdit;
    txtZipCode: TLabeledEdit;
    txtAddressRead: TLabeledEdit;
    txtAddress: TLabeledEdit;
    txtPhoneNumber: TLabeledEdit;
    txtFaxNumber: TLabeledEdit;

    pageResult: TTabSheet;
    gridAddress: TDBGrid;
    btnSelect: TButton;

    lblFaxNumber: TLabel;
    cboFaxNumber: TComboBox;

    procedure txtZipCode_Change(Sender: TObject);

    procedure pageResult_Show(Sender: TObject);
    procedure Address_AfterScroll(DataSet: TDataSet);

    procedure btnSelect_Click(Sender: TObject);
  private
    { Private 錾 }
    procedure Retrieve( var strFaxNumber : String);
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
  end;

var
  FaxNumberChooser: TFaxNumberChooser;

implementation

{$R *.dfm}

uses Set_Address;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function ChooseFaxNumber( _tran : TIBTransaction; var strFaxNumber : String) : Boolean; overload;
begin
	with TFaxNumberChooser.Prepare do
	begin
		if Select( _tran, result) then Retrieve( strFaxNumber);
		Release;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TFaxNumberChooser.Retrieve( var strFaxNumber : String);
begin
	strFaxNumber := cboFaxNumber.Text;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TFaxNumberChooser.BeforePopup();
begin
	AddressOnTheDay.Transaction := Transaction;
	Zip.Transaction := Transaction;
end;

procedure TFaxNumberChooser.AfterPopup();
begin
	ErrorCheck_Empty( 'FAXԍ', cboFaxNumber.Text, ErrorMessages);
	ErrorCheck_Digits( 'FAXԍ', cboFaxNumber.Text, ErrorMessages);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TFaxNumberChooser.txtZipCode_Change(Sender: TObject);
begin
	Zip.ParamByName( 'keyZIP').AsInteger := ToZipCode( txtZipCode.Text);
	Zip.Open;
	if not Zip.IsEmpty then
	begin
		txtAddressRead.Text := Trim( Zip.FieldByName( 'strAddressRead').AsString);
		txtAddress.Text := Trim( Zip.FieldByName( 'strAddress').AsString);
	end
	else
	begin
		txtAddressRead.Text := '';
		txtAddress.Text := '';
	end;
	Zip.Close;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TFaxNumberChooser.pageResult_Show(Sender: TObject);
begin
	with DataSourceOf_Address.DataSet as TIBQuery do
	begin
		Close;
		ParamByName( 'datAvailableAt').AsDate := Today;
		ParamByName( 'typCategory').AsInteger := cboCategory.ItemIndex;
		ParamByName( 'strNameRead').AsString := Trim( txtNameRead.Text);
		ParamByName( 'strName').AsString := Trim( txtName.Text);
		ParamByName( 'strAddressRead').AsString := Trim( txtAddressRead.Text);
		ParamByName( 'strAddress').AsString := Trim( txtAddress.Text);
		ParamByName( 'strPhoneNumber').AsString := ToDigits( txtPhoneNumber.Text);
		ParamByName( 'strFaxNumber').AsString := ToDigits( txtFaxNumber.Text);
		Open;
	end;

	btnSelect.Enabled := not DataSourceOf_Address.DataSet.IsEmpty;
end;

procedure TFaxNumberChooser.Address_AfterScroll(DataSet: TDataSet);
begin
	cboFaxNumber.Items.Clear;
	cboFaxNumber.Items.Add( DataSet.FieldByName( 'strFaxNumber1').AsString);
	cboFaxNumber.Items.Add( DataSet.FieldByName( 'strFaxNumber2').AsString);
	cboFaxNumber.Items.Add( DataSet.FieldByName( 'strFaxNumber3').AsString);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TFaxNumberChooser.btnSelect_Click(Sender: TObject);
begin
	if DataSourceOf_Address.DataSet.IsEmpty then exit;
	TAddressSet.Prepare.Select( DataSourceOf_Address.DataSet.FieldByName( 'keyInstance').AsInteger);
end;

end.
