unit Chooser_Zip;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet, IBQuery,
  IBDatabase, ComCtrls, Grids, DBGrids, Base_Chooser, Misc_Constants, Misc_Utilities;

function ChooseZip( _tran : TIBTransaction; var keyZip : Integer) : Boolean;

type
  TZipChooser = class(TChooserTemplate)
    Zip: TIBQuery;
    DataSourceOf_Zip: TDataSource;

    pagesHolder: TPageControl;

    pageCondition: TTabSheet;
    txtAddressRead: TLabeledEdit;
    txtAddress: TLabeledEdit;

    pageResult: TTabSheet;
    gridZip: TDBGrid;

    procedure pageResult_Show(Sender: TObject);

  private
    { Private 錾 }
    procedure Retrieve( var keyZip : Integer);
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
  end;

var
  ZipChooser: TZipChooser;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function ChooseZip( _tran : TIBTransaction; var keyZip : Integer) : Boolean;
begin
	with TZipChooser.Prepare do
	begin
		if Select( _tran, result) then Retrieve( keyZip);
		Release;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TZipChooser.Retrieve( var keyZip : Integer);
begin
	keyZip := Zip.FieldByName( 'keyZip').AsInteger;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TZipChooser.BeforePopup();
begin
	Zip.Transaction := Transaction;
end;

procedure TZipChooser.AfterPopup();
begin
	if Zip.IsEmpty then
		ErrorMessages.Add( 'X֔ԍIĂ܂B');
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TZipChooser.pageResult_Show(Sender: TObject);
begin
	Zip.Close;
	Zip.ParamByName( 'strAddressRead').AsString := Trim( txtAddressRead.Text);
	Zip.ParamByName( 'strAddress').AsString := Trim( txtAddress.Text);
	Zip.Open;
end;

end.
