unit Dialog_Absence;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet, IBQuery,
  IBDatabase, ComCtrls, DateUtils, Base_Dialog, DBClient, Provider,
  Misc_Constants, Misc_Utilities, Piece_ValiditySelector, Grids;

type
  TAbsenceDialog = class(TDialogTemplate)
    gridCalendar: TDrawGrid;
    txtReason: TLabeledEdit;
    btnInvert: TButton;
    btnClear: TButton;

    procedure gridCalendar_DrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
    procedure gridCalendar_Click(Sender: TObject);

    procedure btnInvert_Click(Sender: TObject);
    procedure btnClear_Click(Sender: TObject);

  private
    { Private 錾 }
    FProfileKey : Integer;
    FMonth : TDate;
    FAbsence : Integer;
  protected
    { Protected 錾 }
    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare( keyProfile : Integer; datDefMonth : TDate); overload;
  end;

var
  AbsenceDialog: TAbsenceDialog;

implementation

{$R *.dfm}

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TAbsenceDialog.Prepare( keyProfile : Integer; datDefMonth : TDate);
begin
	inherited Create( Screen.ActiveForm);

	FProfileKey := keyProfile;
	FMonth := StartOfTheMonth( datDefMonth);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAbsenceDialog.BeforeInput();
begin
end;

procedure TAbsenceDialog.AfterInput();
begin
	with RecordSet do
	begin
		if Appending then Append else Edit;
		if Appending then FieldByName( 'keyInstance').AsInteger := TemporaryKey;
		FieldByName( 'codRevision').AsInteger := FieldByName( 'codRevision').AsInteger;
		FieldByName( 'typStatus').AsInteger := FieldByName( 'typStatus').AsInteger;
		FieldByName( 'refProfile').AsInteger := FProfileKey;
		FieldByName( 'datMonthFirstday').AsDateTime := StartOfTheMonth( FMonth);
		FieldByName( 'datMonthLastday').AsDateTime := EndOfTheMonth( FMonth);
		FieldByName( 'optAbsence').AsInteger := FAbsence;
		FieldByName( 'strReason').AsString := Trim( txtReason.Text);
		Post;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAbsenceDialog.BeforeSelect();
begin
	with RecordSet do
	begin
		FMonth := FieldByName( 'datMonthFirstday').AsDateTime;
		FAbsence := FieldByName( 'optAbsence').AsInteger;
		txtReason.Text := FieldByName( 'strReason').AsString;
	end;
end;

procedure TAbsenceDialog.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAbsenceDialog.BeforeAppend();
begin
	FAbsence := 0;
end;

procedure TAbsenceDialog.AfterAppend();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAbsenceDialog.BeforePopup();
begin
	txtReason.ReadOnly := Browsing;

	Caption := FormatDateTime( '"Γ́"ggee"N"yyyy"N"MM""', FMonth);
end;

procedure TAbsenceDialog.AfterPopup();
begin
	if FAbsence = 0 then
		ErrorMessages.Add( 'Γ͂Ă܂B');

	if Trim( txtReason.Text) = '' then
		ErrorMessages.Add( 'ΗR͂Ă܂B');
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAbsenceDialog.gridCalendar_DrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
const
	aWeekday : array[ 0..6] of String = ( '', '', '', '', '', '', 'y');
var
	DayValue : Integer;
	DayLabel : String;
begin
	with gridCalendar.Canvas do case ACol of
	0 : Font.Color := clRed;
	6 : Font.Color := clBlue;
	else Font.Color := clBlack;
	end;

	if ARow = 0 then
		DayLabel := aWeekday[ ACol]
	else
	begin
		DayValue := 7 * ( ARow - 1) + ACol - DayOfWeek( FMonth) + 2;
		if ( 1 <= DayValue) and ( DayValue <= DaysInMonth( FMonth)) then
		begin
			DayLabel := IntToStr( DayValue);
			if ( FAbsence and ( 1 shl ( DayValue - 1))) <> 0 then
				gridCalendar.Canvas.Brush.Color := clDefaultExcluded
			else
				gridCalendar.Canvas.Brush.Color := clCream;
		end
		else
		begin
			DayLabel := ' ';
			gridCalendar.Canvas.Brush.Color := clCream;
		end;
	end;

	gridCalendar.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, DayLabel);
end;

procedure TAbsenceDialog.gridCalendar_Click(Sender: TObject);
var
	DayValue : Integer;
begin
	DayValue := 7 * ( gridCalendar.Row - 1) + gridCalendar.Col - DayOfWeek( FMonth) + 2;
	if ( 1 <= DayValue) and ( DayValue <= DaysInMonth( FMonth)) then
	begin
		FAbsence := FAbsence xor ( 1 shl ( DayValue - 1));
		gridCalendar.Invalidate;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAbsenceDialog.btnInvert_Click(Sender: TObject);
begin
	FAbsence := ( not FAbsence) and $7FFFFFFF;
	gridCalendar.Invalidate;
end;

procedure TAbsenceDialog.btnClear_Click(Sender: TObject);
begin
	FAbsence := 0;
	gridCalendar.Invalidate;
end;

end.
