unit Dialog_Snapshot;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet, IBQuery,
  IBDatabase, ComCtrls, DateUtils, IBSQL, Base_Dialog, Grids, DBGrids,
  Math, StrUtils, Misc_Constants, Misc_Utilities, Piece_MinutesSelector,
  Piece_ServiceSelector, Piece_ServerSelector, Piece_ProfileSelector,
  Piece_ClientSelector;

type
  TSnapshotDialog = class(TDialogTemplate)

    Service: TServiceSelector;

    LocationFromFrame: TShape;
    LocationFromPanel: TPanel;
    LocationFromLabel: TLabel;
    MinutesFrom: TMinutesSelector;
    txtAddressFrom: TEdit;
    btnBrowseAddressFrom: TButton;

    LocationToFrame: TShape;
    LocationToPanel: TPanel;
    LocationToLabel: TLabel;
    MinutesTo: TMinutesSelector;
    txtAddressTo: TEdit;
    btnBrowseAddressTo: TButton;

    ClientFrame: TShape;
    Client: TClientSelector;

    ServerFrame: TShape;
    Server: TServerSelector;

    procedure btnBrowseAddressFrom_Click(Sender: TObject);
    procedure btnBrowseAddressTo_Click(Sender: TObject);

  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare( Title : String);
  end;

var
  SnapshotDialog: TSnapshotDialog;

implementation

{$R *.dfm}

uses Set_Address;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TSnapshotDialog.Prepare( Title : String);
begin
	inherited Create( Screen.ActiveForm);

	Caption := Title;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSnapshotDialog.BeforePopup();
begin
	with RecordSet do
	begin
		Service.Reset( Transaction,
			FieldByName( 'datSchedule').AsDateTime,
			FieldByName( 'typSchedule').AsInteger,
			FieldByName( 'typProgress').AsInteger,
			FieldByName( 'refService').AsInteger,
			FieldByName( 'refExchange').AsInteger,
			FieldByName( 'strNotice').AsString
		);
		Service.Minutes := FieldByName( 'intMinutesFor').AsInteger;

		case FieldByName( 'typSchedule').AsInteger of
		CARE_SERVICE, MENAGE_SERVICE :
			begin
				Client.lblCaption.Caption := '@p';
				Server.lblCaption.Caption := '@wp[';
			end;
		TRANSFER_SERVICE :
			begin
				Client.lblCaption.Caption := '@p';
				Server.lblCaption.Caption := '@hCo[';
			end;
		MIGRATION_SERVICE :
			begin
				Client.lblCaption.Caption := '@wp[';
				Server.lblCaption.Caption := '@hCo[';
			end;
		end;

		MinutesFrom.Value := FieldByName( 'intMinutesAt').AsInteger;
		MinutesFrom.ReadOnly := true;
		if ( FieldByName( 'typAddressFrom').AsInteger = PROFILE_ADDRESS)
		    and ( FieldByName( 'refResidentFrom').AsInteger = FieldByName( 'refClient').AsInteger) then
			txtAddressFrom.Text := MidStr( Client.lblCaption.Caption, 2, 99) + '̎'
		else
			txtAddressFrom.Text := FieldByName( 'strAddressFrom').AsString;

		MinutesTo.Value := FieldByName( 'intMinutesAt').AsInteger + FieldByName( 'intMinutesFor').AsInteger;
		MinutesTo.ReadOnly := true;
		if ( FieldByName( 'typAddressTo').AsInteger = PROFILE_ADDRESS)
		    and ( FieldByName( 'refResidentTo').AsInteger = FieldByName( 'refClient').AsInteger) then
			txtAddressTo.Text := MidStr( Client.lblCaption.Caption, 2, 99) + '̎'
		else
			txtAddressTo.Text := FieldByName( 'strAddressTo').AsString;

		Client.Reset( Transaction, FieldByName( 'datSchedule').AsDateTime, FieldByName( 'refClient').AsInteger);
		Server.Reset( Transaction, FieldByName( 'datSchedule').AsDateTime, FieldByName( 'refServer').AsInteger);

		Caption := Caption + FormatDateTime( '""yyyy"N"MM""dd"("ddd")"', FieldByName( 'datSchedule').AsDateTime);
	end;
end;

procedure TSnapshotDialog.AfterPopup();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSnapshotDialog.btnBrowseAddressFrom_Click(Sender: TObject);
begin
	TAddressSet.Prepare.Browse( RecordSet.FieldByName( 'refAddressFrom').AsInteger);
end;

procedure TSnapshotDialog.btnBrowseAddressTo_Click(Sender: TObject);
begin
	TAddressSet.Prepare.Browse( RecordSet.FieldByName( 'refAddressTo').AsInteger);
end;

end.
