unit Frame_Clients;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, MainDatastore, StdCtrls, Grids, DBGrids, IBSQL, IBDatabase,
  Provider, DB, DBClient, DBLocal, DBLocalI, DateUtils, Math,
  ActnList, Misc_Constants, Misc_Utilities, Base_Frame;

const
    DAILY_CLIENTS = 0;
    MONTHLY_CLIENTS = 1;

type
  TClientsFrame = class(TFrameTemplate)
    Clients: TIBClientDataSet;
    DataSourceOf_Clients: TDataSource;

    cboCategory: TComboBox;
    btnLookupProfile: TButton;
    gridClients: TDBGrid;
    lblCounter: TLabel;
    btnSelectProfile: TButton;

    Shortcuts: TActionList;
    Shortcut_LookupProfile: TAction;

    procedure cboCategory_Click(Sender: TObject);

    procedure btnSelectProfile_Click(Sender: TObject);
    procedure btnLookupProfile_Click(Sender: TObject);
    procedure gridClients_TitleClick(Column: TColumn);
  private
    { Private 錾 }
    FScheduleAt : TDate;
    FObsolete : Boolean;

    function GetClientKey() : Integer;
    function GetCategory() : Integer;
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;

    property ClientKey : Integer read GetClientKey;
    property ScheduleAt : TDate read FScheduleAt;
    property Category : Integer read GetCategory;
    property Obsolete : Boolean read FObsolete write FObsolete;

    procedure Reset( datAt : TDate);

    procedure Lookup( profileKey : Integer);

    procedure SaveStyleToFile( FileName : String);
    procedure LoadStyleFromFile( FileName : String);
  end;

var
  ClientsFrame: TClientsFrame;

implementation

{$R *.dfm}

uses Chooser_Client, Set_Client;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TClientsFrame.Create(AOwner: TComponent);
begin
	inherited Create( AOwner);

	FScheduleAt := Today;
	FObsolete := false;

	SortByDefault( gridClients);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TClientsFrame.GetClientKey() : Integer;
begin
	if Clients.IsEmpty then
		result := -1
	else
		result := Clients.FieldByName( 'keyInstance').AsInteger;
end;

function TClientsFrame.GetCategory() : Integer;
begin
	result := cboCategory.ItemIndex;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientsFrame.Reset( datAt : TDate);
var
	Position : TDataSetPosition;
begin
	FScheduleAt := datAt;
	// property update

	DisableGridSet( gridClients, Position);
	Clients.Close;
	Clients.Params.ParamByName( 'datSchedule').AsDate := ScheduleAt;
	Clients.Params.ParamByName( 'datMonthFirstday').AsDate := StartOfTheMonth( ScheduleAt);
	Clients.Params.ParamByName( 'datMonthLastday').AsDate := EndOfTheMonth( ScheduleAt);
	Clients.Filter := Format( 'typCategory=%d', [ Category]);
	Clients.Open;
	cboCategory_Click( cboCategory);
	EnableGridSet( gridClients, Position);
	// Clients update

	Obsolete := false;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientsFrame.Lookup( profileKey : Integer);
begin
	Clients.Locate( 'keyInstance', profileKey, []);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientsFrame.SaveStyleToFile( FileName : String);
begin
	gridClients.Columns.SaveToFile( FileName);
end;

procedure TClientsFrame.LoadStyleFromFile( FileName : String);
begin
	gridClients.Columns.LoadFromFile( FileName);
	SortByDefault( gridClients);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientsFrame.cboCategory_Click(Sender: TObject);
begin
	Clients.Filter := Format( 'typCategory=%d', [ Category]);
	lblCounter.Caption := 'vF' + IntToStr( Clients.RecordCount) + ' l';

	btnLookupProfile.Enabled := not Clients.IsEmpty;
	btnSelectProfile.Enabled := btnLookupProfile.Enabled;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientsFrame.btnSelectProfile_Click(Sender: TObject);
begin
	TClientSet.Prepare.Select( ClientKey);
end;

procedure TClientsFrame.btnLookupProfile_Click(Sender: TObject);
var
	keyClient : Integer;
begin
	if not btnLookupProfile.Enabled then exit;
	if ChooseClient( DataStore.MainTransaction, ScheduleAt, keyClient) then
	begin
		Lookup( keyClient);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientsFrame.gridClients_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Clients.IndexFieldNames := 'strCode;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRNAMEREAD' then Clients.IndexFieldNames := 'strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRBRANCH' then Clients.IndexFieldNames := 'strBranch;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRREGION' then Clients.IndexFieldNames := 'strRegion;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRADDRESS' then Clients.IndexFieldNames := 'strAddressRead;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRPHONENUMBER1' then Clients.IndexFieldNames := 'strPhoneNumber1;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRAVAILABILITY' then Clients.IndexFieldNames := 'strAvailability;strNameRead;strName;keyInstance';

	with gridClients.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;

end.
