unit Frame_Reserves;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, MainDatastore, DB, DBClient, Provider, IBCustomDataSet, IBQuery, Math,
  StdCtrls, Grids, DBGrids, IBSQL, IBDatabase, DBLocal, DBLocalI, DateUtils,
  DBCtrls, ActnList, Base_Frame,Misc_Constants, Misc_Utilities;

type
  TReservesFrame = class(TFrameTemplate)

    Schedule: TIBClientDataSet;
    DataSourceOf_Schedule: TDataSource;

    cboCondition: TComboBox;
    cboProgress: TComboBox;
    txtProfileInfo: TEdit;
    btnSelectProfile: TButton;
    btnLookupProfile: TButton;

    gridTable: TDBGrid;

    btnSelectSchedule: TButton;
    lblCounter: TLabel;
    btnSpreadSchedule: TButton;

    Shortcuts: TActionList;
    Shortcut_LookupProfile: TAction;
    btnExtendSchedules: TButton;

    procedure cboSelector_Click(Sender: TObject);

    procedure Schedule_AfterScroll(DataSet: TDataSet);

    procedure btnSelectProfile_Click(Sender: TObject);
    procedure btnLookupProfile_Click(Sender: TObject);

    procedure gridTable_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure gridTable_DragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure gridTable_TitleClick(Column: TColumn);

    procedure btnSelectSchedule_Click(Sender: TObject);
    procedure btnSpreadSchedule_Click(Sender: TObject);
    procedure btnExtendSchedules_Click(Sender: TObject);
  private
    { Private 錾 }
    FScheduleAt : TDate;
    FObsolete : Boolean;

    sc_typPattern, sc_optPattern, sc_typSchedule, sc_intMinutesAt, sc_intMinutesFor : Integer;
    sc_typAddressFrom, sc_refAddressFrom, sc_refResidentFrom, sc_strAddressFrom : Integer;
    sc_typAddressTo, sc_refAddressTo, sc_refResidentTo, sc_strAddressTo : Integer;
    sc_typExchange, sc_curAmountPerCount, sc_curAmountPerHour : Integer;
    sc_refClient, sc_strClient, sc_strClientCode, sc_strClientName, sc_strClientRead, sc_strClientPhone, sc_strClientAddress : Integer;

    function GetClientKey() : Integer;
    function GetReserveKey() : Integer;
    function GetServiceMask() : Integer;
    function GetProgressMask() : Integer;
    function GetConditionName() : String;
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;

    property ClientKey : Integer read GetClientKey;
    property ScheduleAt : TDate read FScheduleAt;
    property ReserveKey : Integer read GetReserveKey;
    property ServiceMask : Integer read GetServiceMask;
    property ProgressMask : Integer read GetProgressMask;
    property ConditionName : String read GetConditionName;
    property Obsolete : Boolean read FObsolete write FObsolete;

    procedure Reset( datAt : TDate);

    procedure SaveStyleToFile( FileName : String);
    procedure LoadStyleFromFile( FileName : String);
  end;

var
  ReservesFrame: TReservesFrame;

implementation

{$R *.dfm}

uses Chooser_Client,
     Set_Client,
     Set_Care,
     Set_Menage,
     Set_Migration,
     Set_Transfer,
     Toolbox_ExtendSchedules,
     Toolbox_CarrySchedules,
     Toolbox_SpreadSchedules;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TReservesFrame.Create(AOwner: TComponent);
begin
	inherited Create( AOwner);

	FScheduleAt := Today;
	FObsolete := false;

	sc_typSchedule := -1; // see procedure Reset( datAt : TDate);

	SortByDefault( gridTable);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TReservesFrame.GetClientKey() : Integer;
begin
	if Schedule.IsEmpty then
		result := -1
	else
		result := Schedule.FieldByName( 'refClient').AsInteger;
end;

function TReservesFrame.GetReserveKey() : Integer;
begin
	if Schedule.IsEmpty then
		result := -1
	else
		result := Schedule.FieldByName( 'keyInstance').AsInteger;
end;

function TReservesFrame.GetServiceMask() : Integer;
begin
	result := aServiceMask[ cboCondition.ItemIndex];
end;

function TReservesFrame.GetProgressMask() : Integer;
begin
	result := aProgressMask[ cboProgress.ItemIndex];
end;

function TReservesFrame.GetConditionName() : String;
begin
	result := cboCondition.Text;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReservesFrame.Reset( datAt : TDate);
var
	Position : TDataSetPosition;
begin
	FScheduleAt := datAt;
	// property update

	DisableGridSet( gridTable, Position);
	Schedule.Close;
	Schedule.Params.ParamByName( 'datFrom').AsDate := StartOfTheMonth( ScheduleAt);
	Schedule.Params.ParamByName( 'datTo').AsDate := EndOfTheMonth( ScheduleAt);
	Schedule.Params.ParamByName( 'optService').AsInteger := ServiceMask;
	Schedule.Params.ParamByName( 'optProgress').AsInteger := ProgressMask;
	Schedule.Open;

	if sc_typSchedule < 0 then
	begin
		sc_typPattern := Schedule.FieldByName( 'typPattern').Index;
		sc_optPattern := Schedule.FieldByName( 'optPattern').Index;
		sc_typSchedule := Schedule.FieldByName( 'typSchedule').Index;
		sc_intMinutesAt  := Schedule.FieldByName( 'intMinutesAt').Index;
		sc_intMinutesFor := Schedule.FieldByName( 'intMinutesFor').Index;
		sc_typExchange := Schedule.FieldByName( 'typExchange').Index;
		sc_curAmountPerCount := Schedule.FieldByName( 'curAmountPerCount').Index;
		sc_curAmountPerHour := Schedule.FieldByName( 'curAmountPerHour').Index;
		sc_typAddressFrom := Schedule.FieldByName( 'typAddressFrom').Index;
		sc_refAddressFrom := Schedule.FieldByName( 'refAddressFrom').Index;
		sc_refResidentFrom := Schedule.FieldByName( 'refResidentFrom').Index;
		sc_strAddressFrom := Schedule.FieldByName( 'strAddressFrom').Index;
		sc_typAddressTo := Schedule.FieldByName( 'typAddressTo').Index;
		sc_refAddressTo := Schedule.FieldByName( 'refAddressTo').Index;
		sc_refResidentTo := Schedule.FieldByName( 'refResidentTo').Index;
		sc_strAddressTo := Schedule.FieldByName( 'strAddressTo').Index;
		sc_refClient  := Schedule.FieldByName( 'refClient').Index;
		sc_strClient  := Schedule.FieldByName( 'strClient').Index;
		sc_strClientCode  := Schedule.FieldByName( 'strClientCode').Index;
		sc_strClientName  := Schedule.FieldByName( 'strClientName').Index;
		sc_strClientRead  := Schedule.FieldByName( 'strClientRead').Index;
		sc_strClientPhone  := Schedule.FieldByName( 'strClientPhone').Index;
		sc_strClientAddress  := Schedule.FieldByName( 'strClientAddress').Index;
		Schedule_AfterScroll( Schedule);
	end;

	lblCounter.Caption := 'vF' + IntToStr( Schedule.RecordCount) + ' ';

	btnSelectSchedule.Enabled := not Schedule.IsEmpty;
	btnSpreadSchedule.Enabled := not Schedule.IsEmpty;
	btnExtendSchedules.Enabled := not Schedule.IsEmpty;

	EnableGridSet( gridTable, Position);
	// Schedule update

	Obsolete := false;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReservesFrame.SaveStyleToFile( FileName : String);
begin
	gridTable.Columns.SaveToFile( FileName);
end;

procedure TReservesFrame.LoadStyleFromFile( FileName : String);
begin
	gridTable.Columns.LoadFromFile( FileName);
	SortByDefault( gridTable);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReservesFrame.cboSelector_Click(Sender: TObject);
begin
	Reset( ScheduleAt);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReservesFrame.Schedule_AfterScroll(DataSet: TDataSet);
begin
	if Schedule.IsEmpty or Schedule.Fields[ sc_refClient].IsNull then
	begin
		txtProfileInfo.Text := 'XXXXX / pҁ@ / 悤@߂ / dbԍP / Z';
		btnSelectProfile.Enabled := false;
		btnLookupProfile.Enabled := false;
	end
	else with Schedule do
	begin
		txtProfileInfo.Text := Format( '%s / %s / %s / %s / %s', [
			Fields[ sc_strClientCode].AsString,
			Fields[ sc_strClientName].AsString,
			Fields[ sc_strClientRead].AsString,
			Fields[ sc_strClientPhone].AsString,
			Fields[ sc_strClientAddress].AsString
		]);
		btnSelectProfile.Enabled := true;
		btnLookupProfile.Enabled := true;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReservesFrame.btnSelectProfile_Click(Sender: TObject);
begin
	TClientSet.Prepare.Select( ClientKey);
end;

procedure TReservesFrame.btnLookupProfile_Click(Sender: TObject);
var
	keyClient : Integer;
begin
	if not btnLookupProfile.Enabled then exit;
	if ChooseClient( DataStore.MainTransaction, ScheduleAt, keyClient) then
	begin
		Schedule.Locate( 'refClient', keyClient, []);
        end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReservesFrame.gridTable_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

	function PatternString( typPattern, optPattern : Integer) : String;
	const
		aWeekdayLabel : array[ 0..6] of String = (
			'', '', '', '', '', '', 'y'
		);

		aMonthdayLabel : array[ 0..30] of String = (
			 '1',  '2',  '3',  '4',  '5',  '6',  '7',
			 '8',  '9', '10', '11', '12', '13', '14',
			'15', '16', '17', '18', '19', '20', '21',
			'22', '23', '24', '25', '26', '27', '28',
			'29', '30', '31'
		);
	var
		index : Integer;
	begin
		result := aPattern[ typPattern];

		case typPattern of
		PATTERN_DAY_OF_THE_EVERY_WEEK, PATTERN_DAY_OF_THE_SECOND_WEEK :
			for index := Low( aWeekdayLabel) to High( aWeekdayLabel) do
			begin
				if ( ( 1 shl index) and optPattern) <> 0 then
				begin
					result := Format( '%s %s', [ result, aWeekdayLabel[ index]]);
				end;
			end;

		PATTERN_DAY_OF_THE_MONTH :
			for index := Low( aMonthdayLabel) to High( aMonthdayLabel) do
			begin
				if ( ( 1 shl index) and optPattern) <> 0 then
				begin
					result := Format( '%s %s', [ result, aMonthdayLabel[ index]]);
				end;
			end;
		else
			exit;
		end;
	end;
var
	strAddressFrom, strAddressTo, strExchange : String;
begin
	if Column.Field.IsNull then
	begin
		gridTable.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, '@');
		exit;
	end;

	if Schedule.Fields[ sc_typPattern].AsInteger = PATTERN_COMPLEX then
		gridTable.Canvas.Brush.Color := IfThen( gdSelected in State, clMaroon, clHazard)
	else
		gridTable.Canvas.Brush.Color := IfThen( gdSelected in State, clHighlight, Column.Color);

	with Column do if Field.Index = sc_typPattern then
	begin
		gridTable.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2,
			PatternString( Field.AsInteger, Schedule.Fields[ sc_optPattern].AsInteger)
		);
		exit;
	end;

	with Column do if Field.Index = sc_intMinutesAt then
	begin
		with gridTable.Canvas do case Schedule.Fields[ sc_typSchedule].AsInteger of
		     CARE_SCHEDULE : TextRect( Rect, Rect.Left + 2, Rect.Top + 2, RangeToText( Field.AsInteger, Schedule.Fields[ sc_intMinutesFor].AsInteger));
		   MENAGE_SCHEDULE : TextRect( Rect, Rect.Left + 2, Rect.Top + 2, RangeToText( Field.AsInteger, Schedule.Fields[ sc_intMinutesFor].AsInteger));
		MIGRATION_SCHEDULE : TextRect( Rect, Rect.Left + 2, Rect.Top + 2, MinutesToText( Field.AsInteger));
		 TRANSFER_SCHEDULE : TextRect( Rect, Rect.Left + 2, Rect.Top + 2, MinutesToText( Field.AsInteger));
		end;
		exit;
	end;

	if Column.Field.Index = sc_strAddressTo then with Schedule, gridTable.Canvas do
	begin
		if ( Fields[ sc_typAddressFrom].AsInteger = PROFILE_ADDRESS)
		    and ( Fields[ sc_refResidentFrom].AsInteger = Fields[ sc_refClient].AsInteger) then
			strAddressFrom := 'p҂̎'
		else
			strAddressFrom := Fields[ sc_strAddressFrom].AsString;

		if ( Fields[ sc_typAddressTo].AsInteger = PROFILE_ADDRESS)
		    and ( Fields[ sc_refResidentTo].AsInteger = Fields[ sc_refClient].AsInteger) then
			strAddressTo := 'p҂̎'
		else
			strAddressTo := Fields[ sc_strAddressTo].AsString;

		case Schedule.Fields[ sc_typSchedule].AsInteger of CARE_SCHEDULE, MENAGE_SCHEDULE :
			TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '%s', [ strAddressFrom]));
		else
			if ( Fields[ sc_typAddressFrom].AsInteger = PROFILE_ADDRESS)
			    and ( Fields[ sc_refResidentFrom].AsInteger = Fields[ sc_refClient].AsInteger) then
				TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '@ %s', [ strAddressTo]))
			else if ( Fields[ sc_typAddressTo].AsInteger = PROFILE_ADDRESS)
			    and ( Fields[ sc_refResidentTo].AsInteger = Fields[ sc_refClient].AsInteger) then
				TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '%s', [ strAddressFrom]))
			else
				TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '@ %s%s', [ strAddressFrom, strAddressTo]));
		end;
		exit;
	end;

	with Column do if Field.Index = sc_typExchange then
	begin
		strExchange := AmountToText(
			Schedule.Fields[ sc_typExchange].AsInteger,
			Schedule.Fields[ sc_curAmountPerCount].AsCurrency,
			Schedule.Fields[ sc_curAmountPerHour].AsCurrency,
			Schedule.Fields[ sc_intMinutesFor].AsInteger
		);
		gridTable.Canvas.TextRect(
			Rect,
			Rect.Right - 2 - gridTable.Canvas.TextWidth( strExchange),
			Rect.Top + 2,
			strExchange
		);
		exit;
	end;

	with Column do if Field.Index = sc_strClient then
	begin
		if Schedule.Fields[ sc_refClient].AsInteger = Schedule.Fields[ sc_refClient].AsInteger then
			gridTable.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Field.AsString)
		else
			gridTable.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, '*' + Field.AsString);
		exit;
	end;

	with Column do if PickList.Count > 0 then
	begin
		gridTable.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, PickList[ Field.AsInteger]);
		exit;
	end;

	gridTable.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReservesFrame.gridTable_DragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
begin
	Accept := false;
end;

procedure TReservesFrame.gridTable_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'TYPPATTERN' then Schedule.IndexFieldNames := 'typPattern;intMinutesAt;intMinutesFor;strService;strAddressToRead;strClientRead';
	if Column.FieldName = 'INTMINUTESAT' then Schedule.IndexFieldNames := 'intMinutesAt;intMinutesFor;strService;strAddressToRead;strClientRead';
	if Column.FieldName = 'STRSERVICE' then Schedule.IndexFieldNames := 'strService;intMinutesAt;intMinutesFor;strAddressToRead;strClientRead';
	if Column.FieldName = 'STRADDRESSTO' then Schedule.IndexFieldNames := 'strAddressToRead;intMinutesAt;intMinutesFor;strService;strClientRead';
	if Column.FieldName = 'STRRECIPIENT' then Schedule.IndexFieldNames := 'strClientRead;intMinutesAt;intMinutesFor;strService;strAddressToRead';
	if Column.FieldName = 'STRSERVER' then Schedule.IndexFieldNames := 'strServerRead;intMinutesAt;intMinutesFor;strService;strAddressToRead;strClientRead';
	if Column.FieldName = 'STRNOTICE' then Schedule.IndexFieldNames := 'strNotice;intMinutesAt;intMinutesFor;strService;strAddressToRead;strClientRead';

	with gridTable.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReservesFrame.btnSelectSchedule_Click(Sender: TObject);
begin
	if Schedule.IsEmpty then exit;
	if Schedule.FieldByName( 'typStatus').AsInteger = DATA_ENABLED then
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		     CARE_SCHEDULE : TCareSet.Prepare.Select( ReserveKey);
		   MENAGE_SCHEDULE : TMenageSet.Prepare.Select( ReserveKey);
		MIGRATION_SCHEDULE : TMigrationSet.Prepare.Select( ReserveKey);
		 TRANSFER_SCHEDULE : TTransferSet.Prepare.Select( ReserveKey);
		end
	else
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		     CARE_SCHEDULE : TCareSet.Prepare.Browse( ReserveKey);
		   MENAGE_SCHEDULE : TMenageSet.Prepare.Browse( ReserveKey);
		MIGRATION_SCHEDULE : TMigrationSet.Prepare.Browse( ReserveKey);
		 TRANSFER_SCHEDULE : TTransferSet.Prepare.Browse( ReserveKey);
		end;
end;

procedure TReservesFrame.btnSpreadSchedule_Click(Sender: TObject);
begin
	if Schedule.FieldByName( 'typPattern').AsInteger = PATTERN_COMPLEX then
		CarrySchedules( ReserveKey)
	else
		SpreadSchedules( ReserveKey);
end;

procedure TReservesFrame.btnExtendSchedules_Click(Sender: TObject);
begin
	ExtendSchedules( Schedule);
end;

end.
