unit Misc_Constants;

interface

uses Graphics, Controls;

const

{*******************************************************************************
  @subject: General
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *******************************************************************************}

{*=========================================================*
  @subject: record status
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

DATA_ENABLED = 0;
DATA_DISABLED = 1;


{*=========================================================*
  @subject: snapshot status
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

GENERATED_STATE = 0;
MODIFIED_STATE = 1;
REMOVED_STATE = 2;


{*=========================================================*
  @subject: catalogue type
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

AVAILABLE_ITEM = 0;
UNAVAILABLE_ITEM = 1;
DISABLED_ITEM = 2;

aCatalogue : array[ AVAILABLE_ITEM..DISABLED_ITEM] of String = (
	'', ' LԊÔ̂̈ꗗ ', ' 폜ꂽ̂̈ꗗ '
);


{*******************************************************************************
  @subject: Center
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *******************************************************************************}

{*=========================================================*
  @subject: per event margin category
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

MARGIN_BY_PERMILLAGE = 0;
MARGIN_BY_PERCOUNT = 1;
MARGIN_BY_MANUAL = 2;


{*******************************************************************************
  @subject: Profile, Notice, Absence
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *******************************************************************************}

{*=========================================================*
  @subject: profile category
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

CLIENT_PROFILE = 0;
SERVER_PROFILE = 1;

aProfile : array[ CLIENT_PROFILE..SERVER_PROFILE] of String = (
	'p', '񋟎'
);


{*=========================================================*
  @subject: sex
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

MALE_SEX = 0;
FEMALE_SEX = 1;

aSex : array[ MALE_SEX..FEMALE_SEX] of String = (
	'j', ''
);


{*=========================================================*
  @subject: availabiity bits
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

SUNDAY_AVAILABLE = 1;
MONDAY_AVAILABLE = 2;
TUESDAY_AVAILABLE = 4;
WEDNESDAY_AVAILABLE = 8;
THURSDAY_AVAILABLE = 16;
FRIDAY_AVAILABLE = 32;
SATURDAY_AVAILABLE = 64;
PROFILE_AVAILABLE = 128;


{*******************************************************************************
  @subject: Address
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *******************************************************************************}

{*=========================================================*
  @subject: address category
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

PROFILE_ADDRESS = 0;
FREQUENT_ADDRESS = 1;
GUARDIAN_ADDRESS = 2;
PUBLIC_ADDRESS = 3;

aAddress : array[ PROFILE_ADDRESS..PUBLIC_ADDRESS] of String = (
	'', 'eށE', '㌩l', '{݈'
);


{*******************************************************************************
  @subject: Service, Exchange
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *******************************************************************************}

{*=========================================================*
  @subject: service category
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

CARE_SERVICE = 0;
MENAGE_SERVICE = 1;
MIGRATION_SERVICE = 2;
TRANSFER_SERVICE = 3;

aServiceMask : array[ 0..6] of Integer = (
	-1, 3, 12, 2, 1, 8, 4
);

aService : array[ CARE_SERVICE..TRANSFER_SERVICE] of String = (
	'',
	'Ǝ',
	'wp[}',
	'ڑ'
);

aServiceInShort : array[ CARE_SERVICE..TRANSFER_SERVICE] of String = (
	'', 'Ǝ', '}', 'ڑ'
);


{*=========================================================*
  @subject: exchange category
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

TICKET_EXCHANGE = 0;
MONEY_EXCHANGE = 1;

aExchange : array[ TICKET_EXCHANGE..MONEY_EXCHANGE] of String = (
	'`Pbg', ''
);


{*******************************************************************************
  @subject: Picture
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************}

{*=========================================================*
  @subject: owner category
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

OWNER_CENTER = 0;
OWNER_PROFILE = 1;
OWNER_ADDRESS = 2;
OWNER_CARE = 3;
OWNER_MENAGE = 4;
OWNER_MIGRATION = 5;
OWNER_TRANSFER = 6;


{*******************************************************************************
  @subject: Schedule
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *******************************************************************************}

{*=========================================================*
  @subject: schedule category
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

CARE_SCHEDULE = CARE_SERVICE;
MENAGE_SCHEDULE = MENAGE_SERVICE;
MIGRATION_SCHEDULE = MIGRATION_SERVICE;
TRANSFER_SCHEDULE = TRANSFER_SERVICE;


{*=========================================================*
  @subject: schedule presence
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

BEFORE_PRESENCE = 0;
AFTER_PRESENCE = 1;
FULL_PRESENCE = 2;
RAW_PRESENCE = 3;


{*=========================================================*
  @subject: schedule pattern
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

PATTERN_SINGLETON = 0;
PATTERN_DAY_OF_THE_EVERY_WEEK = 1;
PATTERN_DAY_OF_THE_SECOND_WEEK = 2;
PATTERN_DAY_OF_THE_MONTH = 3;
PATTERN_COMPLEX = 4;
PATTERN_MULTIPLE = 5;

aPattern : array[ PATTERN_SINGLETON..PATTERN_MULTIPLE] of String = (
	'P', 'T', 'uT', '', '', ''
);


{*=========================================================*
  @subject: sequence pattern
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

SEQUENCE_BODY = 0;
SEQUENCE_TAIL = 1;


{*=========================================================*
  @subject: pattern element
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

ELEMENT_SERVER = 1;
ELEMENT_NOTICE = 2;


{*=========================================================*
  @subject: schedule progress
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

UNCLEAR_PROGRESS = 0;
DEFINED_PROGRESS = 1;

aProgressMask : array[ 0..2] of Integer = (
	-1, 1, 2
);


{*******************************************************************************
  @subject: Comment
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *******************************************************************************}

{*=========================================================*
  @subject: comment category
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

STATIC_COMMENT = 0;
WAITING_COMMENT = 1;
PROCESSED_COMMENT = 2;


{*******************************************************************************
  @subject: Color Constants and Drawing information
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************}

{*=========================================================*
  @subject: schedule color
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

clCare = clNavy;
clMenage = TColor( $C0A080);
clMigration = TColor( $00BBBB);
clTransfer = clMaroon;

aScheduleColor : array[ CARE_SCHEDULE..TRANSFER_SCHEDULE] of TColor = (
	clCare,
	clMenage,
	clMigration,
	clTransfer
);


{*=========================================================*
  @subject: special color
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

clHazard = TColor( $00DDDDFF);

clDefaultExcluded = TColor( $00DDDDFF);
clSelectedExcluded = clMaroon;

clSorted = TColor( $00E8E0E0);


{*=========================================================*
  @subject: drawing information
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

type

TCalendarPacket = record
	calendar : TDate;
	scheduleIndex : Integer;
	prevPlace, nextPlace : String;
	overlapped : Boolean;
	cascaded : Boolean;
end;

TSchedulePacket = record
	instanceKey : Integer;
	scheduleType : Integer;
	progress, presence : Integer;
	minutesFrom, minutesTo, subjectAt : Integer;
	fromX, fromY : Integer;
	toX, toY : Integer;
	opponent : String;
	serverReady : Boolean;
	subjectKey : Integer;
	recordNo : Integer;
	nextIndex : Integer;
end;

implementation

end.
