unit Misc_Locator;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, Math, StdCtrls;

procedure BrowseLocator( X, Y : Integer);
procedure SelectLocator( var X, Y : Integer);

type
  TLocator = class(TForm)
    MapImage: TPaintBox;

    btnOK: TButton;
    btnCancel: TButton;

    procedure Form_Create(Sender: TObject);
    procedure Form_Destroy(Sender: TObject);
    procedure Form_Show(Sender: TObject);

    procedure MapImage_MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure MapImage_Paint(Sender: TObject);
  private
    { Private 錾 }
    FMapPicture : TBitmap;
    FLocatorX : Integer;
    FLocatorY : Integer;
  public
    { Public 錾 }
  end;

var
  Locator: TLocator;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure BrowseLocator( X, Y : Integer);
begin
	with TLocator.Create( Screen.ActiveForm) do
	begin
		FLocatorX := X;
		FLocatorY := Y;

		if FMapPicture.Empty then
		begin
			Application.MessageBox( 'n}摜܂', 'W', MB_OK);
			exit;
		end;

		ShowModal;
		Release;
	end;
end;

procedure SelectLocator( var X, Y : Integer);
begin
	with TLocator.Create( Screen.ActiveForm) do
	begin
		FLocatorX := X;
		FLocatorY := Y;

		if FMapPicture.Empty then
		begin
			Application.MessageBox( 'n}摜܂', 'W', MB_OK);
			exit;
		end;

		if ShowModal() = mrOk then
		begin
			X := FLocatorX;
			Y := FLocatorY;
		end;

		Release;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TLocator.Form_Create(Sender: TObject);
var
	PictureName : String;
begin
	FMapPicture := TBitmap.Create;
	PictureName := ExtractFilePath( Application.ExeName) + 'RouteMap.bmp';
	if FileExists( PictureName) then FMapPicture.LoadFromFile( PictureName);
end;

procedure TLocator.Form_Destroy(Sender: TObject);
begin
	FMapPicture.Free;
end;

procedure TLocator.Form_Show(Sender: TObject);
begin
	ClientWidth := FMapPicture.Width;
	ClientHeight := FMapPicture.Height + btnOK.Height + 16;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TLocator.MapImage_MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	FLocatorX := X;
	FLocatorY := Y;
	MapImage_Paint( Sender);
end;

procedure TLocator.MapImage_Paint(Sender: TObject);
begin
	with MapImage.Canvas do
	begin
		Draw( 0, 0, FMapPicture);

		Font.Color := TColor( $0000C0);
		Font.Height := 20;
		SetBkMode( Handle, TRANSPARENT);
		TextOut( FLocatorX - 10, FLocatorY - 10, '');
	end;
end;

end.
