unit Misc_PictureAlbum;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, DB, DBClient, Provider, IBCustomDataSet, IBQuery,
  Grids, DBGrids, IBDatabase, Misc_Constants, Misc_Utilities;

procedure PopupPictureAlbum( typOwner, keyOwner : Integer);

type
  TPictureAlbum = class(TForm)
    SourceOf_Picture: TIBQuery;
    ProviderOf_Picture: TDataSetProvider;
    Picture: TClientDataSet;
    DataSourceOf_Picture: TDataSource;

    gridPicture: TDBGrid;
    btnSelect: TButton;
    btnAppend: TButton;
    btnDelete: TButton;
    btnClose: TButton;
    Transaction: TIBTransaction;

    procedure Form_Show(Sender: TObject);

    procedure btnSelect_Click(Sender: TObject);
    procedure btnAppend_Click(Sender: TObject);
    procedure btnDelete_Click(Sender: TObject);
  private
    { Private 錾 }
    FOwnerKey : Integer;
    FOwnerType : Integer;
  public
    { Public 錾 }
  end;

var
  PictureAlbum: TPictureAlbum;

implementation

{$R *.dfm}

uses Set_Picture;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure PopupPictureAlbum( typOwner, keyOwner : Integer);
begin
	with TPictureAlbum.Create( Screen.ActiveForm) do
	begin
		FOwnerKey := keyOwner;
		FOwnerType := typOwner;
		ShowModal;
		Release;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPictureAlbum.Form_Show(Sender: TObject);
var
	Position : TDataSetPosition;
begin
	DisableGridSet( gridPicture, Position);
	Picture.Close;
	SourceOf_Picture.ParamByName( 'keyOwner').AsInteger := FOwnerKey;
	Picture.Open;
	EnableGridSet( gridPicture, Position);

	btnSelect.Enabled := not Picture.IsEmpty;
	btnDelete.Enabled := not Picture.IsEmpty;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPictureAlbum.btnSelect_Click(Sender: TObject);
begin
	if Picture.IsEmpty then exit;
	TPictureSet.Prepare.Select( Picture.FieldByName( 'keyInstance').AsInteger);
	Form_Show( self);
end;

procedure TPictureAlbum.btnAppend_Click(Sender: TObject);
begin
	TPictureSet.Prepare( FOwnerType, FOwnerKey).Append;
	Form_Show( self);
end;

procedure TPictureAlbum.btnDelete_Click(Sender: TObject);
begin
	TPictureSet.Prepare.Delete( Picture.FieldByName( 'keyInstance').AsInteger);
	Form_Show( self);
end;

end.
