unit Misc_Scheduler;

interface

uses
  SysUtils, StrUtils, Math, DateUtils, Classes, Controls,
  IBCustomDataSet, IBUpdateSQL, IBSQL, DB, IBQuery, IB, IBDatabase,
  Misc_Constants, Misc_Utilities;

type
  TScheduler = class(TDataModule)
    ScheduleInserter: TIBSQL;
    SubjectFinder: TIBSQL;
  private
    { Private 錾 }
    function IsSequential( datAt : TDate) : Boolean;
  public
    { Public 錾 }
    Transaction : TIBTransaction;

    datAnchor : TDate;

    keyPattern : Integer;
    typPattern : Integer;
    optPattern : Integer;
    optElement : Integer;

    typProgress : Integer;
    refService : Integer;
    refExchange : Integer;

    intMinutesAt : Integer;
    intMinutesFor : Integer;
    refAddressFrom : Integer;
    refAddressTo : Integer;
    strNotice : String;

    refClient : Integer;
    refServer : Integer;

    procedure CopyAsSubject( datLastday : TDate; typLastSequence : Integer = SEQUENCE_TAIL); overload;
    procedure CopyAsSubject(); overload;
    procedure CopyAsLemma( keySubjectPattern : Integer);
  end;

var
  Scheduler: TScheduler;

implementation

{$R *.dfm}

uses MainDatastore;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TScheduler.IsSequential( datAt : TDate) : Boolean;
begin
	case typPattern of
	PATTERN_DAY_OF_THE_EVERY_WEEK :
		result := ( ( ( 1 shl ( DayOfWeek( datAt) - 1)) and optPattern) <> 0);

	PATTERN_DAY_OF_THE_SECOND_WEEK :
		result := ( ( ( 1 shl ( DayOfWeek( datAt) - 1)) and optPattern) <> 0)
				and ( WeeksBetween( StartOfTheWeek( datAt), StartOfTheWeek( datAnchor)) mod 2 = 0);

	PATTERN_DAY_OF_THE_MONTH, PATTERN_COMPLEX, PATTERN_MULTIPLE :
		result := ( ( ( 1 shl ( DayOfTheMonth( datAt) - 1)) and (
				optPattern or ( BoolToInt( IntToBool( ( -1 shl ( DaysInMonth( datAt) - 1)) and optPattern)) shl ( DaysInMonth( datAt) - 1))
			)) <> 0);
	else
		result := false;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TScheduler.CopyAsSubject( datLastday : TDate; typLastSequence : Integer);
var
	datSchedule : TDate;
	typSequence : Integer;
label
	next_follower;
begin
	ScheduleInserter.Transaction := Transaction;

	datSchedule := datLastday;
	typSequence := typLastSequence;

	while datSchedule > datAnchor do with ScheduleInserter do
	begin
		if not IsSequential( datSchedule) then goto next_follower;

		ParamByName( 'typStatus').AsInteger := DATA_ENABLED;
		ParamByName( 'datSchedule').AsDate := datSchedule;

		ParamByName( 'keyPattern').AsInteger := keyPattern;
		ParamByName( 'typPattern').AsInteger := typPattern;
		ParamByName( 'optPattern').AsInteger := optPattern;
		ParamByName( 'optElement').AsInteger := optElement;

		ParamByName( 'typSequence').AsInteger := typSequence;

		ParamByName( 'typProgress').AsInteger := typProgress;
		ParamByName( 'refSubject').AsVariant := ZeroToNull( 0);
		ParamByName( 'refService').AsInteger := refService;
		ParamByName( 'refExchange').AsInteger := refExchange;

		ParamByName( 'intMinutesAt').AsInteger := intMinutesAt;
		ParamByName( 'intMinutesFor').AsInteger := intMinutesFor;
		ParamByName( 'refAddressFrom').AsInteger := refAddressFrom;
		ParamByName( 'refAddressTo').AsInteger := refAddressTo;
		ParamByName( 'strNotice').AsString := IfThen( ( optElement and ELEMENT_NOTICE) <> 0, strNotice, '');

		ParamByName( 'refClient').AsVariant := ZeroToNull( refClient);
		ParamByName( 'refServer').AsVariant := ZeroToNull( IfThen( ( optElement and ELEMENT_SERVER) <> 0, refServer, 0));
		ExecQuery;
		Close;

		typSequence := SEQUENCE_BODY;

	next_follower:
		datSchedule := IncDay( datSchedule, -1);
	end;
end;

procedure TScheduler.CopyAsSubject();
begin
	if typPattern in [ PATTERN_COMPLEX, PATTERN_MULTIPLE] then
		CopyAsSubject( DateOf( EndOfTheMonth( datAnchor)))
	else
		CopyAsSubject( DateOf( EndOfTheMonth( IncMonth( datAnchor))));
end;

procedure TScheduler.CopyAsLemma( keySubjectPattern : Integer);
var
	datSchedule : TDate;
label
	next_follower;
begin
	ScheduleInserter.Transaction := Transaction;
	SubjectFinder.Transaction := Transaction;
	SubjectFinder.ParamByName( 'keyPattern').AsInteger := keySubjectPattern;

	datSchedule := IncDay( datAnchor);

	while true do with ScheduleInserter do
	begin
		if not IsSequential( datSchedule) then goto next_follower;

		SubjectFinder.Close;
		SubjectFinder.ParamByName( 'datSchedule').AsDate := datSchedule;
		SubjectFinder.ExecQuery;

		if SubjectFinder.RecordCount = 0 then break;

		ParamByName( 'typStatus').AsInteger := SubjectFinder.FieldByName( 'typStatus').AsInteger;
		ParamByName( 'datSchedule').AsDate := datSchedule;

		ParamByName( 'keyPattern').AsInteger := keyPattern;
		ParamByName( 'typPattern').AsInteger := typPattern;
		ParamByName( 'optPattern').AsInteger := optPattern;
		ParamByName( 'optElement').AsInteger := optElement;

		ParamByName( 'typSequence').AsInteger := SEQUENCE_BODY;

		ParamByName( 'typProgress').AsInteger := typProgress;
		ParamByName( 'refSubject').AsVariant := SubjectFinder.FieldByName( 'keyInstance').AsInteger;
		ParamByName( 'refService').AsInteger := refService;
		ParamByName( 'refExchange').AsInteger := refExchange;

		ParamByName( 'intMinutesAt').AsInteger := intMinutesAt;
		ParamByName( 'intMinutesFor').AsInteger := intMinutesFor;
		ParamByName( 'refAddressFrom').AsInteger := refAddressFrom;
		ParamByName( 'refAddressTo').AsInteger := refAddressTo;
		ParamByName( 'strNotice').AsString := IfThen( ( optElement and ELEMENT_NOTICE) <> 0, strNotice, '');

		ParamByName( 'refClient').AsVariant := ZeroToNull( refClient);
		ParamByName( 'refServer').AsVariant := ZeroToNull( IfThen( ( optElement and ELEMENT_SERVER) <> 0, refServer, 0));
		ExecQuery;
		Close;

	next_follower:
		datSchedule := IncDay( datSchedule);
	end;
end;

end.
