unit Misc_ZipConfig;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, IBCustomDataSet, IBQuery, StdCtrls, ExtCtrls,
  IBUpdateSQL, IBDatabase, IB, IBErrorCodes,
  Misc_Constants, Misc_Utilities, MainDatastore;

procedure PopupZipConfig();

type
  TZipConfig = class(TForm)
    Transaction: TIBTransaction;
    Zip: TIBQuery;
    UpdaterOf_Zip: TIBUpdateSQL;

    txtZipCode: TLabeledEdit;
    btnChooseZip: TButton;

    txtOldAddress: TLabeledEdit;
    txtOldAddressRead: TLabeledEdit;
    txtNewAddress: TLabeledEdit;
    txtNewAddressRead: TLabeledEdit;

    bvlBorder: TBevel;

    btnOK: TButton;
    btnCancel: TButton;

    procedure Form_Show(Sender: TObject);
    procedure Form_CloseQuery(Sender: TObject; var CanClose: Boolean);

    procedure btnChooseZip_Click(Sender: TObject);
    procedure txtZipCode_Change(Sender: TObject);
  protected
    { Protected 錾 }
  end;

var
  ZipConfig: TZipConfig;

implementation

{$R *.dfm}

uses Chooser_Zip;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure PopupZipConfig();
begin
	with TZipConfig.Create( Screen.ActiveForm) do
	begin
		try
			Transaction.StartTransaction;
		except
			on err : EIBInterBaseError do
			begin
				case err.IBErrorCode of
				isc_lock_conflict : ShowMessage( '֘Af[^̃Rs[^ŎgpłB');
				else                ShowMessage( err.Message);
				end;
			end;
		end;

		if ShowModal() = mrOk then
		begin
			with Zip do
			begin
				Open;
				if txtOldAddress.Text = '*********' then Append else Edit;
				FieldByName( 'keyZip').AsInteger := ToZipCode( txtZipCode.Text);
				FieldByName( 'strAddress').AsString := Trim( txtNewAddress.Text);
				FieldByName( 'strAddressRead').AsString := Trim( txtNewAddressRead.Text);
				Post;
				ApplyUpdates;
			end;

			Transaction.Commit;
		end;

		Release;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TZipConfig.Form_Show(Sender: TObject);
begin
	ClientWidth := btnCancel.Left + btnCancel.Width + 14;
	ClientHeight := btnCancel.Top + btnCancel.Height + 8;
end;

procedure TZipConfig.Form_CloseQuery(Sender: TObject; var CanClose: Boolean);
var
	ErrorMessages : TStrings;
begin
	ErrorMessages := TStringList.Create;

	if ModalResult = mrOk then
	try
		ErrorCheck_Reading( 'VZ݂', txtNewAddressRead.Text, ErrorMessages);
		ErrorCheck_Empty( 'VZ', txtNewAddress.Text, ErrorMessages);

		if ( ErrorMessages.Count = 0) and ( txtOldAddress.Text = '*********') then
		begin
			if Application.MessageBox(
				'o^̗X֔ԍ͂܂B̔ԍƏZVKɓo^܂H',
				'o^̗X֔ԍł',
				MB_YESNO
			) = IDNO
			then
				ErrorMessages.Add( 'f[^݂̏𒆎~܂B');
		end;
	finally
		CanClose := ( ErrorMessages.Count = 0);
		if not CanClose then ShowMessage( ErrorMessages.Text);
		ErrorMessages.Free;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TZipConfig.btnChooseZip_Click(Sender: TObject);
var
	keyZip : Integer;
begin
	if ChooseZip( DataStore.MainTransaction, keyZip) then
	begin
		txtZipCode.Text := ToZipText( keyZip);
		txtNewAddressRead.SetFocus;
	end;
end;

procedure TZipConfig.txtZipCode_Change(Sender: TObject);
begin
	Zip.ParamByName( 'keyZIP').AsInteger := ToZipCode( txtZipCode.Text);
	Zip.Open;
	if not Zip.IsEmpty then
	begin
		txtOldAddressRead.Text := Trim( Zip.FieldByName( 'strAddressRead').AsString);
		txtOldAddress.Text := Trim( Zip.FieldByName( 'strAddress').AsString);
	end
	else
	begin
		txtOldAddressRead.Text := '*********';
		txtOldAddress.Text := '*********';
	end;
	Zip.Close;
end;

end.
