unit Piece_ProfileSelector;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB, IBCustomDataSet, IBQuery, StdCtrls, DBCtrls, Grids, DBGrids, ExtCtrls,
  DateUtils, IBSQL, IBDatabase, Misc_Constants, Misc_Utilities, Set_Profile;

type
  TProfileSelector = class(TFrame)
    Profile: TIBQuery;
    Notice: TIBQuery;
    DataSourceOf_Notice: TDataSource;

    lblCaption: TLabel;
    txtCode: TLabeledEdit;
    btnReleaseProfile: TButton;
    btnChooseProfile: TButton;
    txtName: TEdit;
    btnSelectProfile: TButton;
    txtInfo: TEdit;
    txtAvailability: TEdit;
    gridNotice: TDBGrid;
    txtNotice: TDBMemo;

    procedure Profile_AfterOpen(DataSet: TDataSet);
    procedure btnSelectProfile_Click(Sender: TObject);
    procedure btnReleaseProfile_Click(Sender: TObject);
    procedure btnChooseProfile_Click(Sender: TObject);
  private
    { Private 錾 }
    FReadOnly : Boolean;

    FOnChange : TNotifyEvent;

    function GetTransaction() : TIBTransaction;
    procedure SetTransaction( tran : TIBTransaction);
    function GetAvailableAt() : TDate;
    procedure SetAvailableAt( datAt : TDate);
    function GetKeyValue() : Integer;
    procedure SetKeyValue( keyProfile : Integer);
    function GetSelected() : Boolean;
    function GetCaption() : String;
    procedure SetCaption( AText : String);
    procedure SetReadOnly( AReadOnly : Boolean);
  protected
    { Protected 錾 }
    function ProfileClass() : CProfileSet; virtual; abstract;
    function ChooseProfile( _tran : TIBTransaction; datAvailableAt : TDate; var keyInstance : Integer) : Boolean; virtual; abstract;
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;

    property Transaction : TIBTransaction read GetTransaction write SetTransaction;
    property AvailableAt : TDate read GetAvailableAt write SetAvailableAt;
    property KeyValue : Integer read GetKeyValue write SetKeyValue;
    property Selected : Boolean read GetSelected;
    property Caption : String read GetCaption write SetCaption;
    property ReadOnly : Boolean read FReadOnly write SetReadOnly;

    property OnChange : TNotifyEvent read FOnChange write FOnChange;

    procedure Reset( _tran : TIBTransaction; datAt : TDate; keyProfile : Integer);

    procedure Choose();
  end;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TProfileSelector.Create(AOwner: TComponent);
begin
	inherited Create( AOwner);

	FReadOnly := true;

	FOnChange := nil;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TProfileSelector.GetTransaction() : TIBTransaction;
begin
	result := Profile.Transaction;
end;

procedure TProfileSelector.SetTransaction( tran : TIBTransaction);
begin
	Reset( tran, AvailableAt, KeyValue);
end;

function TProfileSelector.GetAvailableAt() : TDate;
begin
	result := Profile.ParamByName( 'datAvailableAt').AsDate;
end;

procedure TProfileSelector.SetAvailableAt( datAt : TDate);
begin
	Reset( Transaction, datAt, KeyValue);
end;

function TProfileSelector.GetKeyValue() : Integer;
begin
	if Profile.IsEmpty then
		result := -1
	else
		result := Profile.FieldByName( 'keyInstance').AsInteger;
end;

procedure TProfileSelector.SetKeyValue( keyProfile : Integer);
begin
	Reset( Transaction, AvailableAt, keyProfile);
end;

function TProfileSelector.GetSelected() : Boolean;
begin
	result := ( KeyValue > 0);
end;

function TProfileSelector.GetCaption() : String;
begin
	result := lblCaption.Caption;
end;

procedure TProfileSelector.SetCaption( AText : String);
begin
	lblCaption.Caption := AText;
end;

procedure TProfileSelector.SetReadOnly( AReadOnly : Boolean);
begin
	FReadOnly := AReadOnly;

	btnReleaseProfile.Enabled := ( not ReadOnly) and ( not Profile.IsEmpty);
	btnChooseProfile.Enabled := not ReadOnly;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileSelector.Reset( _tran : TIBTransaction; datAt : TDate; keyProfile : Integer);
begin
	Profile.Close;
	Profile.Transaction := _tran;
	Profile.ParamByName( 'datAvailableAt').AsDate := datAt;
	Profile.ParamByName( 'keyInstance').AsInteger := keyProfile;
	Profile.Open;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileSelector.Choose();
begin
	if not ReadOnly then btnSelectProfile.Click;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileSelector.Profile_AfterOpen(DataSet: TDataSet);
begin
	with Profile do if IsEmpty then
	begin
		txtCode.Text := '';
		txtName.Text := 'o^ҁ@ / Ƃ낭@߂';
		txtInfo.Text := 'N /  / dbԍP / FAXԍP / Z';
		txtAvailability.Text := 'l';
		btnSelectProfile.Enabled := false;
		btnReleaseProfile.Enabled := false;
		lblCaption.Color := clHazard;
	end
	else
	begin
		txtCode.Text := Trim( FieldByName( 'strCode').AsString);
		txtName.Text := Trim( FieldByName( 'strNames').AsString);
		txtInfo.Text := Format( '%s / %s / %s', [
			ToAgeText( AvailableAt, FieldByName( 'datBirthday').AsDateTime),
			aSex[ FieldByName( 'typSex').AsInteger],
			Trim( FieldByName( 'strInfos').AsString)
		]);
		txtAvailability.Text := Trim( FieldByName( 'strAvailability').AsString);
		btnSelectProfile.Enabled := true;
		btnReleaseProfile.Enabled := not ReadOnly;
		lblCaption.Color := TColor( $00B0B0B0);
	end;

	Notice.Close;
	Notice.Transaction := Profile.Transaction;
	Notice.ParamByName( 'datAvailableAt').AsDate := Profile.ParamByName( 'datAvailableAt').AsDate;
	Notice.ParamByName( 'keyProfile').AsInteger := Profile.ParamByName( 'keyInstance').AsInteger;
	Notice.Open;

	if @FOnChange <> nil then FOnChange( self);
end;

procedure TProfileSelector.btnSelectProfile_Click(Sender: TObject);
begin
	ProfileClass.Prepare.Select( KeyValue);
	Profile.Close;
	Profile.Open;
end;

procedure TProfileSelector.btnReleaseProfile_Click(Sender: TObject);
begin
	Profile.Close;
	Profile.ParamByName( 'keyInstance').AsInteger := -1;
	Profile.Open;
end;

procedure TProfileSelector.btnChooseProfile_Click(Sender: TObject);
var
	keyProfile : Integer;
begin
	if ChooseProfile( Profile.Transaction, AvailableAt, keyProfile) then
	begin
		KeyValue := keyProfile;
	end;
end;

end.
