unit Piece_RecordSelector;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, DB;

type
  TRecordSelector = class(TFrame)
    btnFirst: TSpeedButton;
    btnPrev: TSpeedButton;
    lblIndex: TLabel;
    btnNext: TSpeedButton;
    btnLast: TSpeedButton;

    procedure btnFirst_Click(Sender : TObject);
    procedure btnPrev_Click(Sender : TObject);
    procedure btnNext_Click(Sender : TObject);
    procedure btnLast_Click(Sender : TObject);
  private
    { Private 錾 }
    FDataSet : TDataSet;
  public
    { Public 錾 }
    property DataSet : TDataSet read FDataSet;

    procedure Reset( _set : TDataSet);
  end;

implementation

{$R *.dfm}

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRecordSelector.Reset( _set : TDataSet);
begin
	FDataSet := _set;

	btnPrev.Enabled := DataSet.RecNo > 1;
	btnFirst.Enabled := btnPrev.Enabled;

	btnNext.Enabled := ( not DataSet.IsEmpty) and ( DataSet.RecNo < DataSet.RecordCount);
	btnLast.Enabled := btnNext.Enabled;

	lblIndex.Caption := Format( '%d / %d', [ DataSet.RecNo, DataSet.RecordCount]);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRecordSelector.btnFirst_Click(Sender : TObject);
begin
	DataSet.First;
	Reset( DataSet);
end;

procedure TRecordSelector.btnPrev_Click(Sender : TObject);
begin
	DataSet.Prior;
	Reset( DataSet);
end;

procedure TRecordSelector.btnNext_Click(Sender : TObject);
begin
	DataSet.Next;
	Reset( DataSet);
end;

procedure TRecordSelector.btnLast_Click(Sender : TObject);
begin
	DataSet.Last;
	Reset( DataSet);
end;

end.
