unit Piece_ValiditySelector;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Math, DateUtils, Misc_Constants, Misc_Utilities, ExtCtrls, ComCtrls;

type
  TValiditySelector = class(TFrame)
    dtpAvailableFrom: TDateTimePicker;
    lblAvailableFrom: TLabel;
    lblOver: TLabel;
    dtpAvailableTo: TDateTimePicker;

    bvlAnchor: TBevel;

    procedure dtpCalendar_Change(Sender: TObject);

  private
    { Private 錾 }
    FReadOnly : Boolean;

    FOnChange : TNotifyEvent;

    function GetAvailableFrom() : TDate;
    procedure SetAvailableFrom( AValue : TDate);
    function GetAvailableTo() : TDate;
    procedure SetAvailableTo( AValue : TDate);
    procedure SetReadOnly( AReadOnly : Boolean);

    procedure UpdateCalendar( dtpCalendar: TDateTimePicker);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;

    property AvailableFrom : TDate read GetAvailableFrom write SetAvailableFrom;
    property AvailableTo : TDate read GetAvailableTo write SetAvailableTo;
    property ReadOnly : Boolean read FReadOnly write SetReadOnly;

    procedure Reset( datFrom, datTo : TDate);

    property OnChange : TNotifyEvent read FOnChange write FOnChange;
  end;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TValiditySelector.Create(AOwner: TComponent);
begin
	inherited Create( AOwner);

	dtpAvailableFrom.Date := Max( Today, dtpAvailableFrom.MinDate);
	dtpAvailableTo.Date := Max( Today, dtpAvailableTo.MinDate);
	FReadOnly := true;

	FOnChange := nil;

	UpdateCalendar( dtpAvailableFrom);
	UpdateCalendar( dtpAvailableTo);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TValiditySelector.GetAvailableFrom() : TDate;
begin
	result := DateOf( Min( dtpAvailableFrom.Date, dtpAvailableTo.Date));
end;

procedure TValiditySelector.SetAvailableFrom( AValue : TDate);
begin
	dtpAvailableFrom.Date := Max( AValue, dtpAvailableFrom.MinDate);
	UpdateCalendar( dtpAvailableFrom);
	if @FOnChange <> nil then FOnChange( self);
end;

function TValiditySelector.GetAvailableTo() : TDate;
begin
	result := DateOf( Max( dtpAvailableTo.Date, dtpAvailableTo.Date));
end;

procedure TValiditySelector.SetAvailableTo( AValue : TDate);
begin
	dtpAvailableTo.Date := Max( AValue, dtpAvailableTo.MinDate);
	UpdateCalendar( dtpAvailableTo);
	if @FOnChange <> nil then FOnChange( self);
end;

procedure TValiditySelector.SetReadOnly( AReadOnly : Boolean);
begin
	FReadOnly := AReadOnly;

	dtpAvailableFrom.Enabled := not ReadOnly;
	dtpAvailableTo.Enabled := not ReadOnly;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TValiditySelector.UpdateCalendar( dtpCalendar: TDateTimePicker);
begin
	dtpCalendar.Format := FormatDateTime( ' gg ee "N"', dtpCalendar.Date) + ' yyyy N MM  dd ';
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TValiditySelector.Reset( datFrom, datTo : TDate);
begin
	dtpAvailableFrom.Date := Min( datFrom, datTo);
	dtpAvailableTo.Date := Max( datFrom, datTo);

	UpdateCalendar( dtpAvailableFrom);
	UpdateCalendar( dtpAvailableTo);

	if @FOnChange <> nil then FOnChange( self);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TValiditySelector.dtpCalendar_Change(Sender: TObject);
begin
	UpdateCalendar( Sender as TDateTimePicker);
	if @FOnChange <> nil then FOnChange( self);
end;

end.
