unit Publisher_BillingLabels;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Publisher, Grids, DBGrids,
  Buttons, Math, Misc_Constants, Misc_Utilities;

type
  TBillingLabelsPublisher = class(TPublisherTemplate)
    SourceOf_Billing: TIBQuery;
    ProviderOf_Billing: TDataSetProvider;
    Billing: TClientDataSet;
    DataSourceOf_Billing: TDataSource;

    pnlTimeStamp: TPanel;
    btnTimeStamp: TButton;

    gridBilling: TDBGrid;

    btnBrowse: TButton;
    btnExclude: TButton;
    btnInvert: TButton;

    pbrProgress: TProgressBar;

    procedure btnTimeStamp_Click(Sender: TObject);

    procedure gridBilling_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure gridBilling_TitleClick(Column: TColumn);

    procedure btnBrowse_Click( Sender : TObject);
    procedure btnExclude_Click( Sender : TObject);
    procedure btnInvert_Click(Sender: TObject);

  private
    { Private 錾 }
    FAvailableAt : TDate;
    FFrom : TDate;
    FTo : TDate;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare( datFrom, datTo : TDate);
  end;

var
  BillingLabelsPublisher: TBillingLabelsPublisher;

implementation

{$R *.dfm}

uses Chooser_Date, Set_Billing, Report_Billing, Report_NameLabels;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TBillingLabelsPublisher.Prepare( datFrom, datTo : TDate);
begin
	inherited Prepare;

	FAvailableAt := Today;
	FFrom := datFrom;
	FTo := datTo;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingLabelsPublisher.BeforePopup();
begin
	Billing.Close;
	SourceOf_Billing.ParamByName( 'datFrom').AsDate := FFrom;
	SourceOf_Billing.ParamByName( 'datTo').AsDate := FTo;
	SourceOf_Billing.ParamByName( 'datAt').AsDate := FAvailableAt;
	Billing.Open;
	// update query

	pnlTimeStamp.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd "" (ddd)', FAvailableAt);

	btnBrowse.Enabled := not Billing.IsEmpty;
	btnExclude.Enabled := not Billing.IsEmpty;
	btnInvert.Enabled := not Billing.IsEmpty;

	gridBilling.SelectedRows.CurrentRowSelected := true;
end;

procedure TBillingLabelsPublisher.AfterPopup();
begin
	TNameLabelsReport.Prepare( Billing).Preview;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingLabelsPublisher.btnTimeStamp_Click(Sender: TObject);
begin
	if ChooseDate( FAvailableAt) then BeforePopup;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingLabelsPublisher.gridBilling_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	selected : Boolean;
	dummy : Integer;
begin
	selected := gridBilling.SelectedRows.Find( Billing.Bookmark, dummy);
	with gridBilling.Canvas do if not IntToBool( Billing.FieldByName( 'blnAvailable').AsInteger) then
	begin
		Font.Color := IfThen( selected, clHighlightText, clWindowText);
		Brush.Color := IfThen( selected, clSelectedExcluded, clDefaultExcluded);
	end
	else
	begin
		Font.Color := IfThen( selected, clHighlightText, Column.Font.Color);
		Brush.Color := IfThen( selected, clHighlight, Column.Color);
	end;

	if Column.Alignment = taRightJustify then
	begin
		gridBilling.Canvas.TextRect(
			Rect, Rect.Right - 2 - gridBilling.Canvas.TextWidth( Column.Field.AsString), Rect.Top + 2, Column.Field.AsString
		);
	end
	else
	begin
		gridBilling.Canvas.TextRect(
			Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString
		);
	end;
end;

procedure TBillingLabelsPublisher.gridBilling_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Billing.IndexFieldNames := 'strCode;datPublished';
	if Column.FieldName = 'STRNAMEREAD' then Billing.IndexFieldNames := 'strNameRead;datPublished';
	if Column.FieldName = 'DATPUBLISHED' then Billing.IndexFieldNames := 'datPublished;strNameRead';
	if Column.FieldName = 'INTMARGIN' then Billing.IndexFieldNames := 'intMargin;strNameRead;datPublished';
	if Column.FieldName = 'INTBILLING' then Billing.IndexFieldNames := 'intBilling;strNameRead;datPublished';

	with gridBilling.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingLabelsPublisher.btnBrowse_Click( Sender : TObject);
begin
	with Billing do if not IsEmpty then TBillingSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
end;

procedure TBillingLabelsPublisher.btnExclude_Click( Sender : TObject);
var
	index : Integer;
begin
	if Billing.IsEmpty then exit;

	Billing.DisableControls;
	for index := 0 to gridBilling.SelectedRows.Count - 1 do
	begin
		with Billing do
		begin
			Bookmark := gridBilling.SelectedRows.Items[ index];
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
		end;
	end;
	gridBilling.SelectedRows.Refresh;
	gridBilling.SelectedRows.CurrentRowSelected := true;
	Billing.EnableControls;
end;

procedure TBillingLabelsPublisher.btnInvert_Click(Sender: TObject);
var
	defaultRecNo : Integer;
begin
        with Billing do
        begin
		if IsEmpty then exit;
		defaultRecNo := RecNo;
        	DisableControls;
		First;
	        while not EOF do
	        begin
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
        	        Next;
	        end;
		RecNo := defaultRecNo;
		EnableControls;
        end;
end;

end.
