unit Publisher_CandidatesName;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Publisher, Grids, DBGrids,
  Buttons, Math, Misc_Constants, Misc_Utilities;

type
  TCandidatesNamePublisher = class(TPublisherTemplate)
    Branch: TIBQuery;
    DataSourceOf_Barnch: TDataSource;

    Region: TIBQuery;
    DataSourceOf_Region: TDataSource;

    pnlAvailableAt: TPanel;
    btnAvailableAt: TButton;
    lblAvailableAt: TLabel;

    lblBranch: TLabel;
    cboBranch: TDBLookupComboBox;
    lblBranchAnd: TLabel;

    lblRegion: TLabel;
    cboRegion: TDBLookupComboBox;
    lblRegionAnd: TLabel;

    lblTitle: TLabel;
    txtTitle: TEdit;
    lblTitleAnd: TLabel;

    lblContent: TLabel;
    txtContent: TEdit;
    lblContentAnd: TLabel;

    cboCategory: TComboBox;
    lblCategory: TLabel;

    txtName: TEdit;
    lblName: TLabel;

    procedure btnAvailableAt_Click(Sender: TObject);

  private
    { Private 錾 }
    FAvailableAt : TDate;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
  end;

  CCandidatesNamePublisher = class of TCandidatesNamePublisher;

var
  CandidatesNamePublisher: TCandidatesNamePublisher;

implementation

{$R *.dfm}

uses Chooser_Date, Report_CandidatesName;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidatesNamePublisher.BeforePopup();
begin
	FAvailableAt := Today;
	pnlAvailableAt.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd "" (ddd)', FAvailableAt);

	Branch.Open;
	Branch.FetchAll;
	SelectComboWithoutFail( cboBranch, -1);

	Region.Open;
	Region.FetchAll;
	SelectComboWithoutFail( cboRegion, -1);
end;

procedure TCandidatesNamePublisher.AfterPopup();
begin
	ErrorCheck_Empty( '̖O', txtName.Text, ErrorMessages);

	if ErrorMessages.Count > 0 then exit;

	TCandidatesNameReport.Prepare(
		FAvailableAt,
		cboBranch.KeyValue,
		cboRegion.KeyValue,
		Trim( txtTitle.Text),
		Trim( txtContent.Text),
		cboCategory.ItemIndex - 1,
		Trim( txtName.Text)
	).Preview;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidatesNamePublisher.btnAvailableAt_Click(Sender: TObject);
begin
	if ChooseDate( FAvailableAt) then
	begin
		pnlAvailableAt.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd "" (ddd)', FAvailableAt);
	end;
end;

end.
