unit Publisher_NameLabels;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Publisher, Grids, DBGrids,
  Buttons, Math, Misc_Constants, Misc_Utilities, Set_Profile, Chooser_Profile;

type
  TNameLabelsPublisher = class(TPublisherTemplate)
    DummyOf_Profile: TIBQuery;
    ProviderOf_Profile: TDataSetProvider;
    Profile: TClientDataSet;
    DataSourceOf_Profile: TDataSource;

    pnlTimeStamp: TPanel;
    btnTimeStamp: TButton;

    gridProfile: TDBGrid;

    btnBrowse: TButton;
    btnAppend: TButton;
    btnRemove: TButton;
    btnClear: TButton;

    procedure btnTimeStamp_Click(Sender: TObject);

    procedure gridProfile_TitleClick(Column: TColumn);

    procedure btnBrowse_Click( Sender : TObject);
    procedure btnAppend_Click(Sender: TObject);
    procedure btnRemove_Click( Sender : TObject);
    procedure btnClear_Click(Sender: TObject);

  private
    { Private 錾 }
    FAvailableAt : TDate;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;

    class function CategoryClass() : CProfileSet; virtual; abstract;
    class function ChooseProfiles( _tran : TIBTransaction; datAvailableAt : TDate; var profiles : TProfileInfos) : Boolean; virtual; abstract;
  public
    { Public 錾 }
  end;

  CNameLabelsPublisher = class of TNameLabelsPublisher;

var
  NameLabelsPublisher: TNameLabelsPublisher;

implementation

{$R *.dfm}

uses Chooser_Date, Report_NameLabels;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TNameLabelsPublisher.BeforePopup();
begin
	FAvailableAt := Today;
	pnlTimeStamp.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd "" (ddd)', FAvailableAt);

	Profile.Open;
end;

procedure TNameLabelsPublisher.AfterPopup();
begin
	TNameLabelsReport.Prepare( Profile).Preview;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TNameLabelsPublisher.btnTimeStamp_Click(Sender: TObject);
begin
	if ChooseDate( FAvailableAt) then
	begin
		pnlTimeStamp.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd "" (ddd)', FAvailableAt);
		btnClear.Click;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TNameLabelsPublisher.gridProfile_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Profile.IndexFieldNames := 'strCode';
	if Column.FieldName = 'STRNAMEREAD' then Profile.IndexFieldNames := 'strNameRead;strName';
	if Column.FieldName = 'STRADDRESS' then Profile.IndexFieldNames := 'strAddressRead;strAddress;strNameRead;strName';

	with gridProfile.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TNameLabelsPublisher.btnBrowse_Click( Sender : TObject);
begin
	with Profile do if not IsEmpty then CategoryClass.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
end;

procedure TNameLabelsPublisher.btnAppend_Click(Sender: TObject);
var
	profiles : TProfileInfos;
	index : Integer;
begin
	if ChooseProfiles( Transaction, FAvailableAt, profiles) then
	begin
		Profile.DisableControls;
		for index := Low( profiles) to High( profiles) do
		begin
			Profile.Append;
			Profile.FieldByName( 'blnAvailable').AsInteger := BoolToInt( true);
			Profile.FieldByName( 'keyInstance').AsInteger := profiles[ index].key;
			Profile.FieldByName( 'strCode').AsString := profiles[ index].code;
			Profile.FieldByName( 'strName').AsString := profiles[ index].familyName + '@' + profiles[ index].firstName;
			Profile.FieldByName( 'strNameRead').AsString := profiles[ index].familyNameRead + '@' + profiles[ index].firstNameRead;
			Profile.FieldByName( 'keyZip').AsInteger := profiles[ index].zip;
			Profile.FieldByName( 'strFullAddress').AsString := profiles[ index].zipAddress + profiles[ index].address;
			Profile.FieldByName( 'strZipAddress').AsString := profiles[ index].zipAddress;
			Profile.FieldByName( 'strAddress').AsString := profiles[ index].address;
			Profile.Post;
		end;
		Profile.EnableControls;
	end;
end;

procedure TNameLabelsPublisher.btnRemove_Click( Sender : TObject);
var
	index : Integer;
begin
	if Profile.IsEmpty then exit;

	for index := 0 to gridProfile.SelectedRows.Count - 1 do
	begin
		with Profile do
		begin
			Bookmark := gridProfile.SelectedRows.Items[ index];
			Delete;
		end;
	end;
end;

procedure TNameLabelsPublisher.btnClear_Click(Sender: TObject);
begin
	Profile.EmptyDataSet;
end;

end.
