unit Publisher_Paybacks;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Publisher, Grids, DBGrids,
  Buttons, Math, Misc_Constants, Misc_Utilities;

type
  TPaybacksPublisher = class(TPublisherTemplate)

    SourceOf_Payback: TIBQuery;
    ProviderOf_Payback: TDataSetProvider;
    Payback: TClientDataSet;
    DataSourceOf_Payback: TDataSource;

    gridPayback: TDBGrid;

    btnBrowse: TButton;
    btnExclude: TButton;
    btnInvert: TButton;

    pbrProgress: TProgressBar;
    btnAbort: TButton;

    procedure gridPayback_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure gridPayback_TitleClick(Column: TColumn);

    procedure btnBrowse_Click( Sender : TObject);
    procedure btnExclude_Click( Sender : TObject);
    procedure btnInvert_Click(Sender: TObject);

    procedure btnAbort_Click(Sender: TObject);

  private
    { Private 錾 }
    FFrom : TDate;
    FTo : TDate;
    FPrinting : Boolean;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare( datFrom, datTo : TDate);
  end;

var
  PaybacksPublisher: TPaybacksPublisher;

implementation

{$R *.dfm}

uses Chooser_Date, Set_Payback, Report_Payback;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TPaybacksPublisher.Prepare( datFrom, datTo : TDate);
begin
	inherited Create( Screen.ActiveForm);

	FFrom := datFrom;
	FTo := datTo;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybacksPublisher.BeforePopup();
begin
	Payback.Close;
	SourceOf_Payback.ParamByName( 'datFrom').AsDate := FFrom;
	SourceOf_Payback.ParamByName( 'datTo').AsDate := FTo;
        Payback.Open;
	// update query

	btnBrowse.Enabled := not Payback.IsEmpty;
	btnExclude.Enabled := not Payback.IsEmpty;
	btnInvert.Enabled := not Payback.IsEmpty;
end;

procedure TPaybacksPublisher.AfterPopup();
begin
	gridPayback.Enabled := false;
	btnBrowse.Enabled := false;
	btnExclude.Enabled := false;
	btnInvert.Enabled := false;
        btnAbort.Enabled := true;
	btnOK.Enabled := false;
	btnCancel.Enabled := false;

	FPrinting := true;

	Payback.First;
	pbrProgress.Max := Payback.RecordCount;
	with Payback do while ( not EOF) and FPrinting do
	begin
		if IntToBool( FieldByName( 'blnAvailable').AsInteger) then
		begin
			TPaybackReport.Prepare( FieldByName( 'keyInstance').AsInteger).Printout;
		end;

		pbrProgress.Position := RecNo;
		Next;

		Application.ProcessMessages;
	end;

	if FPrinting then
	begin
		Application.MessageBox( 'v^ւ̃f[^MI܂', '`PbgZׂ̈ꊇ', MB_OK);
		exit;
	end;

	gridPayback.Enabled := true;
	btnBrowse.Enabled := true;
	btnExclude.Enabled := true;
	btnInvert.Enabled := true;
	btnAbort.Enabled := false;
	btnOK.Enabled := true;
	btnCancel.Enabled := true;
	pbrProgress.Position := 0;

	Application.MessageBox( '𒆒f܂', '`PbgZׂ̈ꊇ', MB_OK);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybacksPublisher.gridPayback_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	selected : Boolean;
	dummy : Integer;
begin
	selected := gridPayback.SelectedRows.Find( Payback.Bookmark, dummy);

	with gridPayback.Canvas do if not IntToBool( Payback.FieldByName( 'blnAvailable').AsInteger) then
	begin
		Font.Color := IfThen( selected, clHighlightText, clWindowText);
		Brush.Color := IfThen( selected, clSelectedExcluded, clDefaultExcluded);
	end
	else
	begin
		Font.Color := IfThen( selected, clHighlightText, Column.Font.Color);
		Brush.Color := IfThen( selected, clHighlight, Column.Color);
	end;

	if Column.Alignment = taRightJustify then
	begin
		gridPayback.Canvas.TextRect(
			Rect, Rect.Right - 2 - gridPayback.Canvas.TextWidth( Column.Field.AsString), Rect.Top + 2, Column.Field.AsString
		);
	end
	else
	begin
		gridPayback.Canvas.TextRect(
			Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString
		);
	end;
end;

procedure TPaybacksPublisher.gridPayback_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Payback.IndexFieldNames := 'strCode;datPublished';
	if Column.FieldName = 'STRNAMEREAD' then Payback.IndexFieldNames := 'strNameRead;datPublished';
	if Column.FieldName = 'DATPUBLISHED' then Payback.IndexFieldNames := 'datPublished;strNameRead';
	if Column.FieldName = 'INTMARGIN' then Payback.IndexFieldNames := 'intMargin;strNameRead;datPublished';
	if Column.FieldName = 'INTPAYBACK' then Payback.IndexFieldNames := 'intPayback;strNameRead;datPublished';

	with gridPayback.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybacksPublisher.btnBrowse_Click( Sender : TObject);
begin
	with Payback do if not IsEmpty then TPaybackSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
end;

procedure TPaybacksPublisher.btnExclude_Click( Sender : TObject);
var
	index : Integer;
begin
	if Payback.IsEmpty then exit;

	Payback.DisableControls;
	for index := 0 to gridPayback.SelectedRows.Count - 1 do
	begin
		with Payback do
		begin
			Bookmark := gridPayback.SelectedRows.Items[ index];
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
		end;
	end;
	gridPayback.SelectedRows.Refresh;
	gridPayback.SelectedRows.CurrentRowSelected := true;
	Payback.EnableControls;
end;

procedure TPaybacksPublisher.btnInvert_Click(Sender: TObject);
var
	defaultRecNo : Integer;
begin
	with Payback do
	begin
		if IsEmpty then exit;
		defaultRecNo := RecNo;
		DisableControls;
		First;
		while not EOF do
		begin
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
			Next;
		end;
		RecNo := defaultRecNo;
		EnableControls;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybacksPublisher.btnAbort_Click(Sender: TObject);
begin
	FPrinting := false;
end;

end.
