unit Publisher_Payments;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Publisher, Grids, DBGrids,
  Buttons, Math, Misc_Constants, Misc_Utilities;

type
  TPaymentsPublisher = class(TPublisherTemplate)

    SourceOf_Payment: TIBQuery;
    ProviderOf_Payment: TDataSetProvider;
    Payment: TClientDataSet;
    DataSourceOf_Payment: TDataSource;

    gridPayment: TDBGrid;

    btnBrowse: TButton;
    btnExclude: TButton;
    btnInvert: TButton;

    pbrProgress: TProgressBar;
    btnAbort: TButton;

    procedure gridPayment_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure gridPayment_TitleClick(Column: TColumn);

    procedure btnBrowse_Click( Sender : TObject);
    procedure btnExclude_Click( Sender : TObject);
    procedure btnInvert_Click(Sender: TObject);

    procedure btnAbort_Click(Sender: TObject);

  private
    { Private 錾 }
    FFrom : TDate;
    FTo : TDate;
    FPrinting : Boolean;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare( datFrom, datTo : TDate);
  end;

var
  PaymentsPublisher: TPaymentsPublisher;

implementation

{$R *.dfm}

uses Chooser_Date, Set_Payment, Report_Payment;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TPaymentsPublisher.Prepare( datFrom, datTo : TDate);
begin
	inherited Create( Screen.ActiveForm);

	FFrom := datFrom;
	FTo := datTo;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentsPublisher.BeforePopup();
begin
	Payment.Close;
	SourceOf_Payment.ParamByName( 'datFrom').AsDate := FFrom;
	SourceOf_Payment.ParamByName( 'datTo').AsDate := FTo;
        Payment.Open;
	// update query

	btnBrowse.Enabled := not Payment.IsEmpty;
	btnExclude.Enabled := not Payment.IsEmpty;
	btnInvert.Enabled := not Payment.IsEmpty;
end;

procedure TPaymentsPublisher.AfterPopup();
begin
	gridPayment.Enabled := false;
	btnBrowse.Enabled := false;
	btnExclude.Enabled := false;
	btnInvert.Enabled := false;
        btnAbort.Enabled := true;
	btnOK.Enabled := false;
	btnCancel.Enabled := false;

	FPrinting := true;

	Payment.First;
	pbrProgress.Max := Payment.RecordCount;
	with Payment do while ( not EOF) and FPrinting do
	begin
		if IntToBool( FieldByName( 'blnAvailable').AsInteger) then
		begin
			TPaymentReport.Prepare( FieldByName( 'keyInstance').AsInteger).Printout;
		end;

		pbrProgress.Position := RecNo;
		Next;

		Application.ProcessMessages;
	end;

	if FPrinting then
	begin
		Application.MessageBox( 'v^ւ̃f[^MI܂', 'Zׂ̈ꊇ', MB_OK);
		exit;
	end;

	gridPayment.Enabled := true;
	btnBrowse.Enabled := true;
	btnExclude.Enabled := true;
	btnInvert.Enabled := true;
	btnAbort.Enabled := false;
	btnOK.Enabled := true;
	btnCancel.Enabled := true;
	pbrProgress.Position := 0;

	Application.MessageBox( '𒆒f܂', 'Zׂ̈ꊇ', MB_OK);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentsPublisher.gridPayment_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	selected : Boolean;
	dummy : Integer;
begin
	selected := gridPayment.SelectedRows.Find( Payment.Bookmark, dummy);

	with gridPayment.Canvas do if not IntToBool( Payment.FieldByName( 'blnAvailable').AsInteger) then
	begin
		Font.Color := IfThen( selected, clHighlightText, clWindowText);
		Brush.Color := IfThen( selected, clSelectedExcluded, clDefaultExcluded);
	end
	else
	begin
		Font.Color := IfThen( selected, clHighlightText, Column.Font.Color);
		Brush.Color := IfThen( selected, clHighlight, Column.Color);
	end;

	if Column.Alignment = taRightJustify then
	begin
		gridPayment.Canvas.TextRect(
			Rect, Rect.Right - 2 - gridPayment.Canvas.TextWidth( Column.Field.AsString), Rect.Top + 2, Column.Field.AsString
		);
	end
	else
	begin
		gridPayment.Canvas.TextRect(
			Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString
		);
	end;
end;

procedure TPaymentsPublisher.gridPayment_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Payment.IndexFieldNames := 'strCode;datPublished';
	if Column.FieldName = 'STRNAMEREAD' then Payment.IndexFieldNames := 'strNameRead;datPublished';
	if Column.FieldName = 'DATPUBLISHED' then Payment.IndexFieldNames := 'datPublished;strNameRead';
	if Column.FieldName = 'INTMARGIN' then Payment.IndexFieldNames := 'intMargin;strNameRead;datPublished';
	if Column.FieldName = 'INTPAYMENT' then Payment.IndexFieldNames := 'intPayment;strNameRead;datPublished';

	with gridPayment.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentsPublisher.btnBrowse_Click( Sender : TObject);
begin
	with Payment do if not IsEmpty then TPaymentSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
end;

procedure TPaymentsPublisher.btnExclude_Click( Sender : TObject);
var
	index : Integer;
begin
	if Payment.IsEmpty then exit;

	Payment.DisableControls;
	for index := 0 to gridPayment.SelectedRows.Count - 1 do
	begin
		with Payment do
		begin
			Bookmark := gridPayment.SelectedRows.Items[ index];
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
		end;
	end;
	gridPayment.SelectedRows.Refresh;
	gridPayment.SelectedRows.CurrentRowSelected := true;
	Payment.EnableControls;
end;

procedure TPaymentsPublisher.btnInvert_Click(Sender: TObject);
var
	defaultRecNo : Integer;
begin
	with Payment do
	begin
		if IsEmpty then exit;
		defaultRecNo := RecNo;
		DisableControls;
		First;
		while not EOF do
		begin
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
			Next;
		end;
		RecNo := defaultRecNo;
		EnableControls;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentsPublisher.btnAbort_Click(Sender: TObject);
begin
	FPrinting := false;
end;

end.
