unit Publisher_TicketLabels;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Publisher, Grids, DBGrids,
  Buttons, Math, Misc_Constants, Misc_Utilities;

type
  TTicketLabelsPublisher = class(TPublisherTemplate)
    SourceOf_Ticket: TIBQuery;
    ProviderOf_Ticket: TDataSetProvider;
    Ticket: TClientDataSet;
    DataSourceOf_Ticket: TDataSource;

    pnlTimeStamp: TPanel;
    btnTimeStamp: TButton;

    gridTicket: TDBGrid;

    btnBrowse: TButton;
    btnExclude: TButton;
    btnInvert: TButton;

    pbrProgress: TProgressBar;

    procedure btnTimeStamp_Click(Sender: TObject);

    procedure gridTicket_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure gridTicket_TitleClick(Column: TColumn);

    procedure btnBrowse_Click( Sender : TObject);
    procedure btnExclude_Click( Sender : TObject);
    procedure btnInvert_Click(Sender: TObject);

  private
    { Private 錾 }
    FAvailableAt : TDate;
    FFrom : TDate;
    FTo : TDate;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare( datFrom, datTo : TDate);
  end;

var
  TicketLabelsPublisher: TTicketLabelsPublisher;

implementation

{$R *.dfm}

uses Chooser_Date, Set_Ticket, Report_Ticket, Report_NameLabels;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TTicketLabelsPublisher.Prepare( datFrom, datTo : TDate);
begin
	inherited Prepare;

	FAvailableAt := Today;
	FFrom := datFrom;
	FTo := datTo;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketLabelsPublisher.BeforePopup();
begin
	Ticket.Close;
	SourceOf_Ticket.ParamByName( 'datFrom').AsDate := FFrom;
	SourceOf_Ticket.ParamByName( 'datTo').AsDate := FTo;
	SourceOf_Ticket.ParamByName( 'datAt').AsDate := FAvailableAt;
	Ticket.Open;
	// update query

	pnlTimeStamp.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd "" (ddd)', FAvailableAt);

	btnBrowse.Enabled := not Ticket.IsEmpty;
	btnExclude.Enabled := not Ticket.IsEmpty;
	btnInvert.Enabled := not Ticket.IsEmpty;

	gridTicket.SelectedRows.CurrentRowSelected := true;
end;

procedure TTicketLabelsPublisher.AfterPopup();
begin
	TNameLabelsReport.Prepare( Ticket).Preview;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketLabelsPublisher.btnTimeStamp_Click(Sender: TObject);
begin
	if ChooseDate( FAvailableAt) then BeforePopup;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketLabelsPublisher.gridTicket_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	selected : Boolean;
	dummy : Integer;
begin
	selected := gridTicket.SelectedRows.Find( Ticket.Bookmark, dummy);
	with gridTicket.Canvas do if not IntToBool( Ticket.FieldByName( 'blnAvailable').AsInteger) then
	begin
		Font.Color := IfThen( selected, clHighlightText, clWindowText);
		Brush.Color := IfThen( selected, clSelectedExcluded, clDefaultExcluded);
	end
	else
	begin
		Font.Color := IfThen( selected, clHighlightText, Column.Font.Color);
		Brush.Color := IfThen( selected, clHighlight, Column.Color);
	end;

	if Column.Alignment = taRightJustify then
	begin
		gridTicket.Canvas.TextRect(
			Rect, Rect.Right - 2 - gridTicket.Canvas.TextWidth( Column.Field.AsString), Rect.Top + 2, Column.Field.AsString
		);
	end
	else
	begin
		gridTicket.Canvas.TextRect(
			Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString
		);
	end;
end;

procedure TTicketLabelsPublisher.gridTicket_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Ticket.IndexFieldNames := 'strCode;datPublished';
	if Column.FieldName = 'STRNAMEREAD' then Ticket.IndexFieldNames := 'strNameRead;datPublished';
	if Column.FieldName = 'DATPUBLISHED' then Ticket.IndexFieldNames := 'datPublished;strNameRead';
	if Column.FieldName = 'INTMARGIN' then Ticket.IndexFieldNames := 'intMargin;strNameRead;datPublished';
	if Column.FieldName = 'INTTICKET' then Ticket.IndexFieldNames := 'intTicket;strNameRead;datPublished';

	with gridTicket.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketLabelsPublisher.btnBrowse_Click( Sender : TObject);
begin
	with Ticket do if not IsEmpty then TTicketSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
end;

procedure TTicketLabelsPublisher.btnExclude_Click( Sender : TObject);
var
	index : Integer;
begin
	if Ticket.IsEmpty then exit;

	Ticket.DisableControls;
	for index := 0 to gridTicket.SelectedRows.Count - 1 do
	begin
		with Ticket do
		begin
			Bookmark := gridTicket.SelectedRows.Items[ index];
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
		end;
	end;
	gridTicket.SelectedRows.Refresh;
	gridTicket.SelectedRows.CurrentRowSelected := true;
	Ticket.EnableControls;
end;

procedure TTicketLabelsPublisher.btnInvert_Click(Sender: TObject);
var
	defaultRecNo : Integer;
begin
        with Ticket do
        begin
		if IsEmpty then exit;
		defaultRecNo := RecNo;
        	DisableControls;
		First;
	        while not EOF do
	        begin
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
        	        Next;
	        end;
		RecNo := defaultRecNo;
		EnableControls;
        end;
end;

end.
