unit Publisher_Tickets;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Publisher, Grids, DBGrids,
  Buttons, Math, Misc_Constants, Misc_Utilities;

type
  TTicketsPublisher = class(TPublisherTemplate)

    SourceOf_Ticket: TIBQuery;
    ProviderOf_Ticket: TDataSetProvider;
    Ticket: TClientDataSet;
    DataSourceOf_Ticket: TDataSource;

    gridTicket: TDBGrid;

    btnBrowse: TButton;
    btnExclude: TButton;
    btnInvert: TButton;

    pbrProgress: TProgressBar;
    btnAbort: TButton;

    procedure gridTicket_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure gridTicket_TitleClick(Column: TColumn);

    procedure btnBrowse_Click( Sender : TObject);
    procedure btnExclude_Click( Sender : TObject);
    procedure btnInvert_Click(Sender: TObject);

    procedure btnAbort_Click(Sender: TObject);

  private
    { Private 錾 }
    FFrom : TDate;
    FTo : TDate;
    FPrinting : Boolean;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare( datFrom, datTo : TDate);
  end;

var
  TicketsPublisher: TTicketsPublisher;

implementation

{$R *.dfm}

uses Chooser_Date, Set_Ticket, Report_Ticket;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TTicketsPublisher.Prepare( datFrom, datTo : TDate);
begin
	inherited Create( Screen.ActiveForm);

	FFrom := datFrom;
	FTo := datTo;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketsPublisher.BeforePopup();
begin
	Ticket.Close;
	SourceOf_Ticket.ParamByName( 'datFrom').AsDate := FFrom;
	SourceOf_Ticket.ParamByName( 'datTo').AsDate := FTo;
        Ticket.Open;
	// update query

	btnBrowse.Enabled := not Ticket.IsEmpty;
	btnExclude.Enabled := not Ticket.IsEmpty;
	btnInvert.Enabled := not Ticket.IsEmpty;
end;

procedure TTicketsPublisher.AfterPopup();
begin
	gridTicket.Enabled := false;
	btnBrowse.Enabled := false;
	btnExclude.Enabled := false;
	btnInvert.Enabled := false;
        btnAbort.Enabled := true;
	btnOK.Enabled := false;
	btnCancel.Enabled := false;

	FPrinting := true;

	Ticket.First;
	pbrProgress.Max := Ticket.RecordCount;
	with Ticket do while ( not EOF) and FPrinting do
	begin
		if IntToBool( FieldByName( 'blnAvailable').AsInteger) then
		begin
			TTicketReport.Prepare( FieldByName( 'keyInstance').AsInteger).Printout;
		end;

		pbrProgress.Position := RecNo;
		Next;

		Application.ProcessMessages;
	end;

	if FPrinting then
	begin
		Application.MessageBox( 'v^ւ̃f[^MI܂', '`Pbgsׂ̈ꊇ', MB_OK);
		exit;
	end;

	gridTicket.Enabled := true;
	btnBrowse.Enabled := true;
	btnExclude.Enabled := true;
	btnInvert.Enabled := true;
	btnAbort.Enabled := false;
	btnOK.Enabled := true;
	btnCancel.Enabled := true;
	pbrProgress.Position := 0;

	Application.MessageBox( '𒆒f܂', '`Pbgsׂ̈ꊇ', MB_OK);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketsPublisher.gridTicket_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	selected : Boolean;
	dummy : Integer;
begin
	selected := gridTicket.SelectedRows.Find( Ticket.Bookmark, dummy);

	with gridTicket.Canvas do if not IntToBool( Ticket.FieldByName( 'blnAvailable').AsInteger) then
	begin
		Font.Color := IfThen( selected, clHighlightText, clWindowText);
		Brush.Color := IfThen( selected, clSelectedExcluded, clDefaultExcluded);
	end
	else
	begin
		Font.Color := IfThen( selected, clHighlightText, Column.Font.Color);
		Brush.Color := IfThen( selected, clHighlight, Column.Color);
	end;

	if Column.Alignment = taRightJustify then
	begin
		gridTicket.Canvas.TextRect(
			Rect, Rect.Right - 2 - gridTicket.Canvas.TextWidth( Column.Field.AsString), Rect.Top + 2, Column.Field.AsString
		);
	end
	else
	begin
		gridTicket.Canvas.TextRect(
			Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString
		);
	end;
end;

procedure TTicketsPublisher.gridTicket_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Ticket.IndexFieldNames := 'strCode;datPublished';
	if Column.FieldName = 'STRNAMEREAD' then Ticket.IndexFieldNames := 'strNameRead;datPublished';
	if Column.FieldName = 'DATPUBLISHED' then Ticket.IndexFieldNames := 'datPublished;strNameRead';
	if Column.FieldName = 'INTMARGIN' then Ticket.IndexFieldNames := 'intMargin;strNameRead;datPublished';
	if Column.FieldName = 'INTTICKET' then Ticket.IndexFieldNames := 'intTicket;strNameRead;datPublished';

	with gridTicket.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketsPublisher.btnBrowse_Click( Sender : TObject);
begin
	with Ticket do if not IsEmpty then TTicketSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
end;

procedure TTicketsPublisher.btnExclude_Click( Sender : TObject);
var
	index : Integer;
begin
	if Ticket.IsEmpty then exit;

	Ticket.DisableControls;
	for index := 0 to gridTicket.SelectedRows.Count - 1 do
	begin
		with Ticket do
		begin
			Bookmark := gridTicket.SelectedRows.Items[ index];
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
		end;
	end;
	gridTicket.SelectedRows.Refresh;
	gridTicket.SelectedRows.CurrentRowSelected := true;
	Ticket.EnableControls;
end;

procedure TTicketsPublisher.btnInvert_Click(Sender: TObject);
var
	defaultRecNo : Integer;
begin
	with Ticket do
	begin
		if IsEmpty then exit;
		defaultRecNo := RecNo;
		DisableControls;
		First;
		while not EOF do
		begin
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
			Next;
		end;
		RecNo := defaultRecNo;
		EnableControls;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketsPublisher.btnAbort_Click(Sender: TObject);
begin
	FPrinting := false;
end;

end.
