unit Report_Address;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore, Misc_Constants, Misc_Utilities;

type
  TAddressReport = class(TReportTemplate)

    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    FlexReportPanel3: TFlexReportPanel;
    bTableDetail: TFlexReportBand;
    rName: TFlexReportPanel;
    FlexReportPanel2: TFlexReportPanel;
    rNameRead: TFlexReportPanel;
    FlexReportLayout1: TFlexReportLayout;
    FlexReportBand1: TFlexReportBand;
    FlexReportPanel5: TFlexReportPanel;
    rAddressRead: TFlexReportPanel;
    FlexReportBand2: TFlexReportBand;
    FlexReportPanel8: TFlexReportPanel;
    FlexReportPanel9: TFlexReportPanel;
    rAddress: TFlexReportPanel;
    rZip: TFlexReportPanel;
    FlexReportLayout2: TFlexReportLayout;
    FlexReportBand3: TFlexReportBand;
    FlexReportPanel12: TFlexReportPanel;
    rFaxNumber3: TFlexReportPanel;
    FlexReportBand4: TFlexReportBand;
    FlexReportPanel14: TFlexReportPanel;
    rFaxNumber2: TFlexReportPanel;
    FlexReportBand5: TFlexReportBand;
    FlexReportPanel16: TFlexReportPanel;
    rFaxNumber1: TFlexReportPanel;
    FlexReportLayout3: TFlexReportLayout;
    FlexReportBand6: TFlexReportBand;
    FlexReportPanel11: TFlexReportPanel;
    rPhoneNumber3: TFlexReportPanel;
    FlexReportBand7: TFlexReportBand;
    FlexReportPanel19: TFlexReportPanel;
    rPhoneNumber2: TFlexReportPanel;
    FlexReportBand8: TFlexReportBand;
    FlexReportPanel21: TFlexReportPanel;
    rPhoneNumber1: TFlexReportPanel;
    MainTransaction: TIBTransaction;
    Address: TIBQuery;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( keyInstance : Integer);
  end;

var
  AddressReport: TAddressReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TAddressReport.Prepare( keyInstance : Integer);
begin
	inherited Create( Screen.ActiveForm);

	Address.ParamByName( 'keyInstance').AsInteger := keyInstance;
	Address.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Address.IsEmpty);
end;

procedure TAddressReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	rNameRead.Lines.Text := Address.FieldByName( 'strNameRead').AsString;
	rName.Lines.Text := Address.FieldByName( 'strName').AsString;

	rZip.Lines.Text := '' + ToZipText( Address.FieldByName( 'refZip').AsInteger);
	rAddressRead.Lines.Text := Address.FieldByName( 'strAddressRead').AsString;
	rAddress.Lines.Text := Address.FieldByName( 'strAddress').AsString;

	rPhoneNumber1.Lines.Text := Address.FieldByName( 'strPhoneNumber1').AsString;
	rPhoneNumber2.Lines.Text := Address.FieldByName( 'strPhoneNumber2').AsString;
	rPhoneNumber3.Lines.Text := Address.FieldByName( 'strPhoneNumber3').AsString;

	rFaxNumber1.Lines.Text := Address.FieldByName( 'strFaxNumber1').AsString;
	rFaxNumber2.Lines.Text := Address.FieldByName( 'strFaxNumber2').AsString;
	rFaxNumber3.Lines.Text := Address.FieldByName( 'strFaxNumber3').AsString;
end;

end.
